/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.converter;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.converter.ColumnInfo;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class TableColumnInfo {
    private Table table;
    private List<ColumnInfo> columnInfos;

    public TableColumnInfo() {
    }

    public TableColumnInfo(Table table, List<ColumnInfo> columnInfos) {
        this.table = table;
        this.columnInfos = columnInfos;
    }

    public List<Column> getNotIdColumns() {
        if (CollectionUtils.isEmpty(this.columnInfos)) {
            return Collections.emptyList();
        }
        return this.columnInfos.stream().filter(c -> !c.isId()).map(ColumnInfo::getColumn).collect(Collectors.toList());
    }

    public List<Column> getIds() {
        if (CollectionUtils.isEmpty(this.columnInfos)) {
            return Collections.emptyList();
        }
        return this.columnInfos.stream().filter(ColumnInfo::isId).map(ColumnInfo::getColumn).collect(Collectors.toList());
    }

    public List<Column> getColumns() {
        if (CollectionUtils.isEmpty(this.columnInfos)) {
            return Collections.emptyList();
        }
        return this.columnInfos.stream().map(ColumnInfo::getColumn).collect(Collectors.toList());
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public void setColumnInfos(List<ColumnInfo> columnInfos) {
        this.columnInfos = columnInfos;
    }
}

