/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.exception;

public class SqlException
extends RuntimeException {
    public SqlException(String message) {
        super(message);
    }

    public static SqlException columnValueNotFound() {
        return new SqlException("Column value not found!");
    }

    public static SqlException idInvalidUpdate(String table, String id) {
        return new SqlException("Table(" + table + ")'s id(" + id + ") cannot be updated");
    }

    public static SqlException idNotFound(String table) {
        return new SqlException("Table(" + table + ") id not found");
    }

    public static SqlException idNullPointer(String table, String id) {
        return new SqlException("Table(" + table + ")'s id(" + id + ") is null!");
    }

    public static SqlException idValueNotFound() {
        return new SqlException("Id value not found");
    }

    public static SqlException uniqueKeyValueNotFound() {
        return new SqlException("Unique key value not found");
    }

    public static SqlException columnNullPointer(String table, String column) {
        return new SqlException("Table(" + table + ")'s column(" + column + ") is null!");
    }

    public static SqlException idAutoIncrease(String table, String id) {
        return new SqlException("Table(" + table + ")'s id(" + id + ") cannot be inserted!");
    }

    public static SqlException multiIdNotSupported(String table) {
        return new SqlException("Table(" + table + ") has more than one id");
    }

    public static SqlException tableNotMatched(String exceptTable, String actualTable) {
        return new SqlException("Table not match, except[" + exceptTable + "], actual[" + actualTable + "]");
    }

    public static SqlException columnNotFound() {
        return new SqlException("Column not found");
    }

    public static SqlException tableNotFound() {
        return new SqlException("Table not found");
    }
}

