/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import tech.ibit.sqlbuilder.AggregateColumn;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.JoinOn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.exception.SqlException;
import tech.ibit.sqlbuilder.sql.CountSql;
import tech.ibit.sqlbuilder.sql.support.UseAliasSupport;
import tech.ibit.sqlbuilder.sql.support.impl.ColumnSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.DistinctSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.FromSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.GroupBySupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.HavingSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.JoinOnSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.sql.support.impl.WhereSupportImpl;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class CountSqlImpl
implements CountSql,
UseAliasSupport,
PrepareStatementBuildSupport {
    private DistinctSupportImpl<CountSql> distinctSupport;
    private ColumnSupportImpl<CountSql> columnSupport;
    private FromSupportImpl<CountSql> fromSupport;
    private JoinOnSupportImpl<CountSql> joinOnSupport;
    private WhereSupportImpl<CountSql> whereSupport;
    private GroupBySupportImpl<CountSql> groupBySupport;
    private HavingSupportImpl<CountSql> havingSupport;

    public CountSqlImpl() {
        this(true);
    }

    public CountSqlImpl(boolean needToInit) {
        if (needToInit) {
            this.columnSupport = new ColumnSupportImpl<CountSqlImpl>(this);
            this.fromSupport = new FromSupportImpl<CountSqlImpl>(this);
            this.distinctSupport = new DistinctSupportImpl<CountSqlImpl>(this);
            this.joinOnSupport = new JoinOnSupportImpl<CountSqlImpl>(this);
            this.whereSupport = new WhereSupportImpl<CountSqlImpl>(this);
            this.groupBySupport = new GroupBySupportImpl<CountSqlImpl>(this);
            this.havingSupport = new HavingSupportImpl<CountSqlImpl>(this);
        }
    }

    @Override
    public CountSql column(List<? extends IColumn> columns) {
        return this.columnSupport.column(columns);
    }

    @Override
    public CountSql column(IColumn column) {
        return this.columnSupport.column(column);
    }

    @Override
    public CountSql columnPo(Class<?> poClass) {
        return this.columnSupport.columnPo(poClass);
    }

    @Override
    public CountSql from(Table table) {
        return this.fromSupport.from(table);
    }

    @Override
    public CountSql from(List<Table> tables) {
        return this.fromSupport.from(tables);
    }

    @Override
    public CountSql distinct() {
        return this.distinctSupport.distinct();
    }

    @Override
    public CountSql distinct(boolean distinct) {
        return this.distinctSupport.distinct(distinct);
    }

    @Override
    public CountSql having(Criteria having) {
        return this.havingSupport.having(having);
    }

    @Override
    public CountSql having(List<Criteria> havings) {
        return this.havingSupport.having(havings);
    }

    @Override
    public CountSql andHaving(CriteriaItem havingItem) {
        return this.havingSupport.andHaving(havingItem);
    }

    @Override
    public CountSql andHaving(List<Criteria> havings) {
        return this.havingSupport.andHaving(havings);
    }

    @Override
    public CountSql orHaving(CriteriaItem havingItem) {
        return this.havingSupport.orHaving(havingItem);
    }

    @Override
    public CountSql orHaving(List<Criteria> havings) {
        return this.havingSupport.orHaving(havings);
    }

    @Override
    public CountSql joinOn(JoinOn joinOn) {
        return this.joinOnSupport.joinOn(joinOn);
    }

    @Override
    public CountSql joinOn(List<JoinOn> joinOns) {
        return this.joinOnSupport.joinOn(joinOns);
    }

    @Override
    public CountSql joinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.joinOn(table, columnPairs);
    }

    @Override
    public CountSql leftJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.leftJoinOn(table, columnPairs);
    }

    @Override
    public CountSql rightJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.rightJoinOn(table, columnPairs);
    }

    @Override
    public CountSql fullJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.fullJoinOn(table, columnPairs);
    }

    @Override
    public CountSql innerJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.innerJoinOn(table, columnPairs);
    }

    @Override
    public CountSql complexLeftJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexLeftJoinOn(table, criteriaItems);
    }

    @Override
    public CountSql complexRightJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexRightJoinOn(table, criteriaItems);
    }

    @Override
    public CountSql complexFullJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexFullJoinOn(table, criteriaItems);
    }

    @Override
    public CountSql complexInnerJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexInnerJoinOn(table, criteriaItems);
    }

    @Override
    public CountSql where(Criteria criteria) {
        return this.whereSupport.where(criteria);
    }

    @Override
    public CountSql where(List<Criteria> criterion) {
        return this.whereSupport.where(criterion);
    }

    @Override
    public CountSql andWhere(CriteriaItem item) {
        return this.whereSupport.andWhere(item);
    }

    @Override
    public CountSql andWhere(List<Criteria> criterion) {
        return this.whereSupport.andWhere(criterion);
    }

    @Override
    public CountSql orWhere(CriteriaItem item) {
        return this.whereSupport.orWhere(item);
    }

    @Override
    public CountSql orWhere(List<Criteria> criterion) {
        return this.whereSupport.orWhere(criterion);
    }

    @Override
    public CountSql groupBy(Column groupBy) {
        return this.groupBySupport.groupBy(groupBy);
    }

    @Override
    public CountSql groupBy(List<Column> groupBys) {
        return this.groupBySupport.groupBy(groupBys);
    }

    @Override
    public boolean isUseAlias() {
        return true;
    }

    public void setDistinctSupport(DistinctSupportImpl<CountSql> distinctSupport) {
        this.distinctSupport = distinctSupport;
    }

    public void setColumnSupport(ColumnSupportImpl<CountSql> columnSupport) {
        this.columnSupport = columnSupport;
    }

    public void setFromSupport(FromSupportImpl<CountSql> fromSupport) {
        this.fromSupport = fromSupport;
    }

    public void setJoinOnSupport(JoinOnSupportImpl<CountSql> joinOnSupport) {
        this.joinOnSupport = joinOnSupport;
    }

    public void setWhereSupport(WhereSupportImpl<CountSql> whereSupport) {
        this.whereSupport = whereSupport;
    }

    public void setGroupBySupport(GroupBySupportImpl<CountSql> groupBySupport) {
        this.groupBySupport = groupBySupport;
    }

    public void setHavingSupport(HavingSupportImpl<CountSql> havingSupport) {
        this.havingSupport = havingSupport;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        List<IColumn> columns;
        boolean hasAggregateColumn;
        List<Column> groupColumns = this.groupBySupport.getGroupByColumns();
        if (CollectionUtils.isNotEmpty(groupColumns)) {
            this.distinct();
            this.columnSupport.resetColumn(groupColumns);
        }
        boolean useAlias = this.isUseAlias();
        String columnStr = null;
        if (CollectionUtils.isEmpty(groupColumns) && (hasAggregateColumn = (columns = this.columnSupport.getColumn().getItems()).stream().anyMatch(column -> column instanceof AggregateColumn))) {
            this.distinct();
            columnStr = "1";
        }
        if (null == columnStr) {
            PrepareStatement columnPrepareStatement = this.columnSupport.getColumnPrepareStatement(useAlias);
            columnStr = columnPrepareStatement.getPrepareSql();
        }
        boolean distinct = this.distinctSupport.getDistinct().isValue();
        if (StringUtils.isBlank(columnStr) && distinct) {
            throw new SqlException("Columns cannot be empty while at distinct statement!");
        }
        if (CollectionUtils.isEmpty(this.fromSupport.getTable().getItems())) {
            throw SqlException.tableNotFound();
        }
        StringBuilder prepareSql = new StringBuilder();
        prepareSql.append("SELECT COUNT(").append(distinct ? "DISTINCT " + columnStr : "*").append(")");
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        this.append(Arrays.asList(this.fromSupport.getFromPrepareStatement(useAlias), this.joinOnSupport.getJoinOnPrepareStatement(useAlias), this.whereSupport.getWherePrepareStatement(useAlias), this.havingSupport.getHavingPrepareStatement(useAlias)), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }
}

