/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.JoinOn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.exception.SqlException;
import tech.ibit.sqlbuilder.sql.DeleteSql;
import tech.ibit.sqlbuilder.sql.support.UseAliasSupport;
import tech.ibit.sqlbuilder.sql.support.impl.DeleteSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.FromSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.JoinOnSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.sql.support.impl.WhereSupportImpl;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class DeleteSqlImpl
implements DeleteSql,
UseAliasSupport,
PrepareStatementBuildSupport {
    private final DeleteSupportImpl<DeleteSql> deleteSupport = new DeleteSupportImpl<DeleteSqlImpl>(this);
    private final FromSupportImpl<DeleteSql> fromSupport = new FromSupportImpl<DeleteSqlImpl>(this);
    private final WhereSupportImpl<DeleteSql> whereSupport = new WhereSupportImpl<DeleteSqlImpl>(this);
    private final JoinOnSupportImpl<DeleteSql> joinOnSupport = new JoinOnSupportImpl<DeleteSqlImpl>(this);

    @Override
    public DeleteSql delete(Table table) {
        return this.deleteSupport.delete(table);
    }

    @Override
    public DeleteSql delete(List<Table> tables) {
        return this.deleteSupport.delete(tables);
    }

    @Override
    public DeleteSql from(Table table) {
        return this.fromSupport.from(table);
    }

    @Override
    public DeleteSql from(List<Table> tables) {
        return this.fromSupport.from(tables);
    }

    @Override
    public DeleteSql joinOn(JoinOn joinOn) {
        return this.joinOnSupport.joinOn(joinOn);
    }

    @Override
    public DeleteSql joinOn(List<JoinOn> joinOns) {
        return this.joinOnSupport.joinOn(joinOns);
    }

    @Override
    public DeleteSql joinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.joinOn(table, columnPairs);
    }

    @Override
    public DeleteSql leftJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.leftJoinOn(table, columnPairs);
    }

    @Override
    public DeleteSql rightJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.rightJoinOn(table, columnPairs);
    }

    @Override
    public DeleteSql fullJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.fullJoinOn(table, columnPairs);
    }

    @Override
    public DeleteSql innerJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.innerJoinOn(table, columnPairs);
    }

    @Override
    public DeleteSql complexLeftJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexLeftJoinOn(table, criteriaItems);
    }

    @Override
    public DeleteSql complexRightJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexRightJoinOn(table, criteriaItems);
    }

    @Override
    public DeleteSql complexFullJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexFullJoinOn(table, criteriaItems);
    }

    @Override
    public DeleteSql complexInnerJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexInnerJoinOn(table, criteriaItems);
    }

    @Override
    public DeleteSql where(Criteria criteria) {
        return this.whereSupport.where(criteria);
    }

    @Override
    public DeleteSql where(List<Criteria> criterion) {
        return this.whereSupport.where(criterion);
    }

    @Override
    public DeleteSql andWhere(CriteriaItem item) {
        return this.whereSupport.andWhere(item);
    }

    @Override
    public DeleteSql andWhere(List<Criteria> criterion) {
        return this.whereSupport.andWhere(criterion);
    }

    @Override
    public DeleteSql orWhere(CriteriaItem item) {
        return this.whereSupport.orWhere(item);
    }

    @Override
    public DeleteSql orWhere(List<Criteria> criterion) {
        return this.whereSupport.orWhere(criterion);
    }

    @Override
    public boolean isUseAlias() {
        return this.isMultiTables();
    }

    private boolean isMultiTables() {
        return this.fromSupport.getTable().getItems().size() > 1 || this.joinOnSupport.getJoinOn().getItems().size() > 0;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        if (this.whereSupport.getWhere().getItems().isEmpty()) {
            throw new SqlException("Where cannot be empty when do deleting!");
        }
        if (CollectionUtils.isEmpty(this.fromSupport.getTable().getItems())) {
            throw SqlException.tableNotFound();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        boolean useAlias = this.isUseAlias();
        boolean multiTables = this.isMultiTables();
        prepareSql.append("DELETE");
        this.append(Arrays.asList(this.deleteSupport.getDeleteItemPrepareStatement(multiTables), this.fromSupport.getFromPrepareStatement(useAlias), this.joinOnSupport.getJoinOnPrepareStatement(useAlias), this.whereSupport.getWherePrepareStatement(useAlias)), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    @Override
    public DeleteSql deleteFrom(Table table) {
        this.delete(table);
        this.from(table);
        return this;
    }

    @Override
    public DeleteSql deleteFrom(List<Table> tables) {
        this.delete((List)tables);
        this.from((List)tables);
        return this;
    }
}

