/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.IOrderBy;
import tech.ibit.sqlbuilder.JoinOn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.exception.SqlException;
import tech.ibit.sqlbuilder.sql.CountSql;
import tech.ibit.sqlbuilder.sql.QuerySql;
import tech.ibit.sqlbuilder.sql.impl.CountSqlImpl;
import tech.ibit.sqlbuilder.sql.support.UseAliasSupport;
import tech.ibit.sqlbuilder.sql.support.impl.ColumnSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.DistinctSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.FromSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.GroupBySupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.HavingSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.JoinOnSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.LimitSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.OrderBySupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.sql.support.impl.WhereSupportImpl;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class QuerySqlImpl
implements QuerySql,
UseAliasSupport,
PrepareStatementBuildSupport {
    private final ColumnSupportImpl<QuerySql> columnSupport = new ColumnSupportImpl<QuerySqlImpl>(this);
    private final FromSupportImpl<QuerySql> fromSupport = new FromSupportImpl<QuerySqlImpl>(this);
    private final DistinctSupportImpl<QuerySql> distinctSupport;
    private final JoinOnSupportImpl<QuerySql> joinOnSupport = new JoinOnSupportImpl<QuerySqlImpl>(this);
    private final WhereSupportImpl<QuerySql> whereSupport = new WhereSupportImpl<QuerySqlImpl>(this);
    private final GroupBySupportImpl<QuerySql> groupBySupport = new GroupBySupportImpl<QuerySqlImpl>(this);
    private final HavingSupportImpl<QuerySql> havingSupport;
    private final OrderBySupportImpl<QuerySql> orderBySupport;
    private final LimitSupportImpl<QuerySql> limitSupport;

    public QuerySqlImpl() {
        this.distinctSupport = new DistinctSupportImpl<QuerySqlImpl>(this);
        this.havingSupport = new HavingSupportImpl<QuerySqlImpl>(this);
        this.orderBySupport = new OrderBySupportImpl<QuerySqlImpl>(this);
        this.limitSupport = new LimitSupportImpl<QuerySqlImpl>(this);
    }

    @Override
    public QuerySql column(List<? extends IColumn> columns) {
        return this.columnSupport.column(columns);
    }

    @Override
    public QuerySql column(IColumn column) {
        return this.columnSupport.column(column);
    }

    @Override
    public QuerySql columnPo(Class<?> poClass) {
        return this.columnSupport.columnPo(poClass);
    }

    @Override
    public QuerySql from(Table table) {
        return this.fromSupport.from(table);
    }

    @Override
    public QuerySql from(List<Table> tables) {
        return this.fromSupport.from(tables);
    }

    @Override
    public QuerySql distinct() {
        return this.distinctSupport.distinct();
    }

    @Override
    public QuerySql distinct(boolean distinct) {
        return this.distinctSupport.distinct(distinct);
    }

    @Override
    public QuerySql having(Criteria having) {
        return this.havingSupport.having(having);
    }

    @Override
    public QuerySql having(List<Criteria> havings) {
        return this.havingSupport.having(havings);
    }

    @Override
    public QuerySql andHaving(CriteriaItem havingItem) {
        return this.havingSupport.andHaving(havingItem);
    }

    @Override
    public QuerySql andHaving(List<Criteria> havings) {
        return this.havingSupport.andHaving(havings);
    }

    @Override
    public QuerySql orHaving(CriteriaItem havingItem) {
        return this.havingSupport.orHaving(havingItem);
    }

    @Override
    public QuerySql orHaving(List<Criteria> havings) {
        return this.havingSupport.orHaving(havings);
    }

    @Override
    public QuerySql joinOn(JoinOn joinOn) {
        return this.joinOnSupport.joinOn(joinOn);
    }

    @Override
    public QuerySql joinOn(List<JoinOn> joinOns) {
        return this.joinOnSupport.joinOn(joinOns);
    }

    @Override
    public QuerySql joinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.joinOn(table, columnPairs);
    }

    @Override
    public QuerySql leftJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.leftJoinOn(table, columnPairs);
    }

    @Override
    public QuerySql rightJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.rightJoinOn(table, columnPairs);
    }

    @Override
    public QuerySql fullJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.fullJoinOn(table, columnPairs);
    }

    @Override
    public QuerySql innerJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.innerJoinOn(table, columnPairs);
    }

    @Override
    public QuerySql complexLeftJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexLeftJoinOn(table, criteriaItems);
    }

    @Override
    public QuerySql complexRightJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexRightJoinOn(table, criteriaItems);
    }

    @Override
    public QuerySql complexFullJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexFullJoinOn(table, criteriaItems);
    }

    @Override
    public QuerySql complexInnerJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexInnerJoinOn(table, criteriaItems);
    }

    @Override
    public QuerySql where(Criteria criteria) {
        return this.whereSupport.where(criteria);
    }

    @Override
    public QuerySql where(List<Criteria> criterion) {
        return this.whereSupport.where(criterion);
    }

    @Override
    public QuerySql andWhere(CriteriaItem item) {
        return this.whereSupport.andWhere(item);
    }

    @Override
    public QuerySql andWhere(List<Criteria> criterion) {
        return this.whereSupport.andWhere(criterion);
    }

    @Override
    public QuerySql orWhere(CriteriaItem item) {
        return this.whereSupport.orWhere(item);
    }

    @Override
    public QuerySql orWhere(List<Criteria> criterion) {
        return this.whereSupport.orWhere(criterion);
    }

    @Override
    public QuerySql groupBy(Column groupBy) {
        return this.groupBySupport.groupBy(groupBy);
    }

    @Override
    public QuerySql groupBy(List<Column> groupBys) {
        return this.groupBySupport.groupBy(groupBys);
    }

    @Override
    public QuerySql orderBy(IOrderBy orderBy) {
        return this.orderBySupport.orderBy(orderBy);
    }

    @Override
    public QuerySql orderBy(List<IOrderBy> orderBys) {
        return this.orderBySupport.orderBy(orderBys);
    }

    @Override
    public QuerySql orderBy(IColumn column) {
        return this.orderBySupport.orderBy(column);
    }

    @Override
    public QuerySql orderBy(IColumn column, boolean desc) {
        return this.orderBySupport.orderBy(column, desc);
    }

    @Override
    public QuerySql limit(int start, int limit) {
        return this.limitSupport.limit(start, limit);
    }

    @Override
    public QuerySql limit(int limit) {
        return this.limitSupport.limit(limit);
    }

    @Override
    public boolean isUseAlias() {
        return true;
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        if (CollectionUtils.isEmpty(this.columnSupport.getColumn().getItems())) {
            throw SqlException.columnNotFound();
        }
        if (CollectionUtils.isEmpty(this.fromSupport.getTable().getItems())) {
            throw SqlException.tableNotFound();
        }
        boolean distinct = this.distinctSupport.getDistinct().isValue();
        StringBuilder prepareSql = new StringBuilder();
        prepareSql.append(distinct ? "SELECT DISTINCT " : "SELECT ");
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        boolean useAlias = this.isUseAlias();
        this.append(Arrays.asList(this.columnSupport.getColumnPrepareStatement(useAlias), this.fromSupport.getFromPrepareStatement(useAlias), this.joinOnSupport.getJoinOnPrepareStatement(useAlias), this.whereSupport.getWherePrepareStatement(useAlias), this.groupBySupport.getGroupByPrepareStatement(useAlias), this.havingSupport.getHavingPrepareStatement(useAlias), this.orderBySupport.getOrderByPrepareStatement(useAlias), this.limitSupport.getLimitPrepareStatement()), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    @Override
    public CountSql toCountSql() {
        CountSqlImpl countSql = new CountSqlImpl(false);
        countSql.setDistinctSupport(this.distinctSupport.copy(countSql));
        countSql.setFromSupport(this.fromSupport.copy(countSql));
        countSql.setJoinOnSupport(this.joinOnSupport.copy(countSql));
        countSql.setWhereSupport(this.whereSupport.copy(countSql));
        countSql.setGroupBySupport(this.groupBySupport.copy(countSql));
        countSql.setHavingSupport(this.havingSupport.copy(countSql));
        countSql.setColumnSupport(this.columnSupport.copy(countSql));
        return countSql;
    }
}

