/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.JoinOn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.SetItem;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.exception.SqlException;
import tech.ibit.sqlbuilder.sql.UpdateSql;
import tech.ibit.sqlbuilder.sql.support.UseAliasSupport;
import tech.ibit.sqlbuilder.sql.support.impl.JoinOnSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.sql.support.impl.SetSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.UpdateTableSupportImpl;
import tech.ibit.sqlbuilder.sql.support.impl.WhereSupportImpl;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class UpdateSqlImpl
implements UpdateSql,
UseAliasSupport,
PrepareStatementBuildSupport {
    private final UpdateTableSupportImpl<UpdateSql> updateTableSupport = new UpdateTableSupportImpl<UpdateSqlImpl>(this);
    private final SetSupportImpl<UpdateSql> setSupport = new SetSupportImpl<UpdateSqlImpl>(this);
    private final JoinOnSupportImpl<UpdateSql> joinOnSupport = new JoinOnSupportImpl<UpdateSqlImpl>(this);
    private final WhereSupportImpl<UpdateSql> whereSupport = new WhereSupportImpl<UpdateSqlImpl>(this);

    @Override
    public boolean isUseAlias() {
        return true;
    }

    @Override
    public UpdateSql update(Table table) {
        return this.updateTableSupport.update(table);
    }

    @Override
    public UpdateSql update(List<Table> tables) {
        return this.updateTableSupport.update(tables);
    }

    @Override
    public UpdateSql set(SetItem item) {
        return this.setSupport.set(item);
    }

    @Override
    public UpdateSql set(List<SetItem> items) {
        return this.setSupport.set(items);
    }

    @Override
    public UpdateSql set(Column column, Object value) {
        return this.setSupport.set(column, value);
    }

    @Override
    public UpdateSql increaseSet(Column column, Number value) {
        return this.setSupport.increaseSet(column, value);
    }

    @Override
    public UpdateSql decreaseSet(Column column, Number value) {
        return this.setSupport.decreaseSet(column, value);
    }

    @Override
    public UpdateSql joinOn(JoinOn joinOn) {
        return this.joinOnSupport.joinOn(joinOn);
    }

    @Override
    public UpdateSql joinOn(List<JoinOn> joinOns) {
        return this.joinOnSupport.joinOn(joinOns);
    }

    @Override
    public UpdateSql joinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.joinOn(table, columnPairs);
    }

    @Override
    public UpdateSql leftJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.leftJoinOn(table, columnPairs);
    }

    @Override
    public UpdateSql rightJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.rightJoinOn(table, columnPairs);
    }

    @Override
    public UpdateSql fullJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.fullJoinOn(table, columnPairs);
    }

    @Override
    public UpdateSql innerJoinOn(Table table, List<Column> columnPairs) {
        return this.joinOnSupport.innerJoinOn(table, columnPairs);
    }

    @Override
    public UpdateSql complexLeftJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexLeftJoinOn(table, criteriaItems);
    }

    @Override
    public UpdateSql complexRightJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexRightJoinOn(table, criteriaItems);
    }

    @Override
    public UpdateSql complexFullJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexFullJoinOn(table, criteriaItems);
    }

    @Override
    public UpdateSql complexInnerJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        return this.joinOnSupport.complexInnerJoinOn(table, criteriaItems);
    }

    @Override
    public UpdateSql where(Criteria criteria) {
        return this.whereSupport.where(criteria);
    }

    @Override
    public UpdateSql where(List<Criteria> criterion) {
        return this.whereSupport.where(criterion);
    }

    @Override
    public UpdateSql andWhere(CriteriaItem item) {
        return this.whereSupport.andWhere(item);
    }

    @Override
    public UpdateSql andWhere(List<Criteria> criterion) {
        return this.whereSupport.andWhere(criterion);
    }

    @Override
    public UpdateSql orWhere(CriteriaItem item) {
        return this.whereSupport.orWhere(item);
    }

    @Override
    public UpdateSql orWhere(List<Criteria> criterion) {
        return this.whereSupport.orWhere(criterion);
    }

    @Override
    public PrepareStatement getPrepareStatement() {
        if (this.whereSupport.getWhere().getItems().isEmpty()) {
            throw new SqlException("Where cannot be empty when do updating!");
        }
        if (this.setSupport.getSet().getItems().isEmpty()) {
            throw new SqlException("Set cannot be empty when do updating!");
        }
        if (CollectionUtils.isEmpty(this.updateTableSupport.getTable().getItems())) {
            throw SqlException.tableNotFound();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        boolean useAlias = this.isUseAlias();
        this.append(Arrays.asList(this.updateTableSupport.getUpdatePrepareStatement(useAlias), this.joinOnSupport.getJoinOnPrepareStatement(useAlias), this.setSupport.getSetItemPrepareStatement(useAlias), this.whereSupport.getWherePrepareStatement(useAlias)), prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }
}

