/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.FullTextColumn;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.converter.EntityConverter;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.ColumnSupport;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class ColumnSupportImpl<T>
implements SqlSupport<T>,
ColumnSupport<T>,
PrepareStatementBuildSupport {
    private final T sql;
    private final ListField<IColumn> column;

    public ColumnSupportImpl(T sql) {
        this(sql, new ListField<IColumn>());
    }

    private ColumnSupportImpl(T sql, ListField<IColumn> column) {
        this.sql = sql;
        this.column = column;
    }

    public <K> ColumnSupportImpl<K> copy(K sql) {
        return new ColumnSupportImpl<K>(sql, this.column.copy());
    }

    public T resetColumn(List<? extends IColumn> columns) {
        this.column.setItems(columns.stream().map(c -> c).collect(Collectors.toList()));
        return this.getSql();
    }

    public ListField<IColumn> getColumn() {
        return this.column;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T column(List<? extends IColumn> columns) {
        this.getColumn().addItems(columns);
        return this.getSql();
    }

    @Override
    public T column(IColumn column) {
        this.getColumn().addItem(column);
        return this.getSql();
    }

    @Override
    public T columnPo(Class<?> poClass) {
        this.getColumn().addItems(EntityConverter.getColumns(poClass));
        return this.getSql();
    }

    public PrepareStatement getColumnPrepareStatement(boolean useAlias) {
        List<IColumn> columns = this.getColumn().getItems();
        if (CollectionUtils.isEmpty(columns)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement("", columns, (T column) -> column.getSelectColumnName(useAlias), (T column) -> {
            if (column instanceof FullTextColumn) {
                return Collections.singletonList(column.value(((FullTextColumn)column).getValue()));
            }
            return null;
        }, ", ");
    }
}

