/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.List;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.DeleteSupport;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class DeleteSupportImpl<T>
implements SqlSupport<T>,
DeleteSupport<T>,
PrepareStatementBuildSupport {
    private final T sql;
    private final ListField<Table> deleteItem;

    public DeleteSupportImpl(T sql) {
        this.sql = sql;
        this.deleteItem = new ListField();
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    private ListField<Table> getDeleteItem() {
        return this.deleteItem;
    }

    @Override
    public T delete(Table table) {
        this.getDeleteItem().addItem(table);
        return this.getSql();
    }

    @Override
    public T delete(List<Table> tables) {
        this.getDeleteItem().addItems(tables);
        return this.getSql();
    }

    public PrepareStatement getDeleteItemPrepareStatement(boolean multiTable) {
        if (!multiTable) {
            return PrepareStatement.empty();
        }
        List<Table> deleteTables = this.getDeleteItem().getItems();
        if (CollectionUtils.isEmpty(deleteTables)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement(" ", deleteTables, (T table) -> table.getSelectTableName(true) + ".*", null, ", ");
    }
}

