/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.Collections;
import java.util.List;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.GroupBySupport;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class GroupBySupportImpl<T>
implements SqlSupport<T>,
GroupBySupport<T>,
PrepareStatementBuildSupport {
    private final T sql;
    private final ListField<Column> groupBy;

    public GroupBySupportImpl(T sql) {
        this(sql, new ListField<Column>());
    }

    private GroupBySupportImpl(T sql, ListField<Column> groupBy) {
        this.sql = sql;
        this.groupBy = groupBy;
    }

    public <K> GroupBySupportImpl<K> copy(K sql) {
        return new GroupBySupportImpl<K>(sql, this.groupBy.copy());
    }

    public List<Column> getGroupByColumns() {
        return null == this.groupBy ? Collections.emptyList() : (CollectionUtils.isEmpty(this.groupBy.getItems()) ? Collections.emptyList() : this.groupBy.getItems());
    }

    private ListField<Column> getGroupBy() {
        return this.groupBy;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T groupBy(Column groupBy) {
        this.getGroupBy().addItem(groupBy);
        return this.getSql();
    }

    @Override
    public T groupBy(List<Column> groupBys) {
        this.getGroupBy().addItems(groupBys);
        return this.getSql();
    }

    public PrepareStatement getGroupByPrepareStatement(boolean useAlias) {
        List<Column> groupBys = this.getGroupBy().getItems();
        if (CollectionUtils.isEmpty(groupBys)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement(" GROUP BY ", groupBys, (T groupBy) -> groupBy.getCompareColumnName(useAlias), null, ", ");
    }
}

