/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.List;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.JoinOn;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.JoinOnSupport;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class JoinOnSupportImpl<T>
implements SqlSupport<T>,
JoinOnSupport<T>,
PrepareStatementBuildSupport {
    private final T sql;
    private final ListField<JoinOn> joinOn;

    public JoinOnSupportImpl(T sql) {
        this(sql, new ListField<JoinOn>());
    }

    private JoinOnSupportImpl(T sql, ListField<JoinOn> joinOn) {
        this.sql = sql;
        this.joinOn = joinOn;
    }

    public <K> JoinOnSupportImpl<K> copy(K sql) {
        return new JoinOnSupportImpl<K>(sql, this.joinOn.copy());
    }

    public ListField<JoinOn> getJoinOn() {
        return this.joinOn;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T joinOn(JoinOn joinOn) {
        this.getJoinOn().addItem(joinOn);
        return this.getSql();
    }

    @Override
    public T joinOn(List<JoinOn> joinOns) {
        this.getJoinOn().addItems(joinOns);
        return this.getSql();
    }

    @Override
    public T joinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.none(table, columnPairs));
        return this.getSql();
    }

    @Override
    public T leftJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.left(table, columnPairs));
        return this.getSql();
    }

    @Override
    public T rightJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.right(table, columnPairs));
        return this.getSql();
    }

    @Override
    public T fullJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.full(table, columnPairs));
        return this.getSql();
    }

    @Override
    public T innerJoinOn(Table table, List<Column> columnPairs) {
        this.joinOn(JoinOn.inner(table, columnPairs));
        return this.getSql();
    }

    @Override
    public T complexLeftJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.left(table, null, criteriaItems));
        return this.getSql();
    }

    @Override
    public T complexRightJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.right(table, null, criteriaItems));
        return this.getSql();
    }

    @Override
    public T complexFullJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.full(table, null, criteriaItems));
        return this.getSql();
    }

    @Override
    public T complexInnerJoinOn(Table table, List<CriteriaItem> criteriaItems) {
        this.joinOn(JoinOn.inner(table, null, criteriaItems));
        return this.getSql();
    }

    public PrepareStatement getJoinOnPrepareStatement(boolean useAlias) {
        List<JoinOn> joinOns = this.getJoinOn().getItems();
        if (CollectionUtils.isEmpty(joinOns)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement(" ", joinOns, " ", useAlias);
    }
}

