/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.Arrays;
import java.util.List;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.SimpleNameColumn;
import tech.ibit.sqlbuilder.sql.field.LimitField;
import tech.ibit.sqlbuilder.sql.support.LimitSupport;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;

public class LimitSupportImpl<T>
implements SqlSupport<T>,
LimitSupport<T> {
    private final T sql;
    private final LimitField limit;

    public LimitSupportImpl(T sql) {
        this.sql = sql;
        this.limit = new LimitField();
    }

    public LimitField getLimit() {
        return this.limit;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T limit(int start, int limit) {
        this.getLimit().limit(start, limit);
        return this.getSql();
    }

    @Override
    public T limit(int limit) {
        this.getLimit().limit(limit);
        return this.getSql();
    }

    public PrepareStatement getLimitPrepareStatement() {
        LimitField limitField = this.getLimit();
        int limit = limitField.getLimit();
        if (limit < 0) {
            return PrepareStatement.empty();
        }
        int start = limitField.getStart();
        String prepareSql = " LIMIT ?, ?";
        List<ColumnValue> values = Arrays.asList(new ColumnValue(new SimpleNameColumn("$start"), start), new ColumnValue(new SimpleNameColumn("$limit"), limit));
        return new PrepareStatement(prepareSql, values);
    }
}

