/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.Collections;
import java.util.List;
import tech.ibit.sqlbuilder.IColumn;
import tech.ibit.sqlbuilder.IOrderBy;
import tech.ibit.sqlbuilder.OrderBy;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.OrderBySupport;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class OrderBySupportImpl<T>
implements SqlSupport<T>,
OrderBySupport<T>,
PrepareStatementBuildSupport {
    private final T sql;
    private final ListField<IOrderBy> orderBy;

    public OrderBySupportImpl(T sql) {
        this.sql = sql;
        this.orderBy = new ListField();
    }

    private ListField<IOrderBy> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T orderBy(IOrderBy orderBy) {
        this.getOrderBy().addItem(orderBy);
        return this.getSql();
    }

    @Override
    public T orderBy(List<IOrderBy> orderBys) {
        this.getOrderBy().addItems(orderBys);
        return this.getSql();
    }

    @Override
    public T orderBy(IColumn column) {
        return this.orderBy(column, false);
    }

    @Override
    public T orderBy(IColumn column, boolean desc) {
        if (null != column) {
            this.getOrderBy().addItem(new OrderBy(column, desc));
        }
        return this.getSql();
    }

    public PrepareStatement getOrderByPrepareStatement(boolean useAlias) {
        List<IOrderBy> orderBys = this.getOrderBy().getItems();
        if (CollectionUtils.isEmpty(orderBys)) {
            return new PrepareStatement("", Collections.emptyList());
        }
        return this.getPrepareStatement(" ORDER BY ", orderBys, ", ", useAlias);
    }
}

