/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.PrepareStatementSupplier;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public interface PrepareStatementBuildSupport {
    default public <T> PrepareStatement getPrepareStatement(String hook, List<T> clauses, Function<T, String> prepareSqlGetter, Function<T, List<ColumnValue>> valuesGetter, String separator, String close) {
        if (CollectionUtils.isEmpty(clauses)) {
            return PrepareStatement.empty();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        prepareSql.append(hook);
        for (int i = 0; i < clauses.size(); ++i) {
            List<ColumnValue> cvs;
            T clause = clauses.get(i);
            if (i != 0) {
                prepareSql.append(separator);
            }
            prepareSql.append(prepareSqlGetter.apply(clause));
            if (null == valuesGetter || !CollectionUtils.isNotEmpty(cvs = valuesGetter.apply(clause))) continue;
            values.addAll(cvs);
        }
        prepareSql.append(close);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    default public <T> PrepareStatement getPrepareStatement(String hook, List<T> clauses, Function<T, String> prepareSqlGetter, Function<T, List<ColumnValue>> valuesGetter, String separator) {
        return this.getPrepareStatement(hook, clauses, prepareSqlGetter, valuesGetter, separator, "");
    }

    default public PrepareStatement getPrepareStatement(String hook, List<? extends PrepareStatementSupplier> clauses, String separator, String close, boolean useAlias) {
        if (CollectionUtils.isEmpty(clauses)) {
            return PrepareStatement.empty();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        prepareSql.append(hook);
        for (int i = 0; i < clauses.size(); ++i) {
            PrepareStatementSupplier clause = clauses.get(i);
            if (i != 0) {
                prepareSql.append(separator);
            }
            PrepareStatement clausePrepareStatement = clause.getPrepareStatement(useAlias);
            prepareSql.append(clausePrepareStatement.getPrepareSql());
            values.addAll(clausePrepareStatement.getValues());
        }
        prepareSql.append(close);
        return new PrepareStatement(prepareSql.toString(), values);
    }

    default public PrepareStatement getPrepareStatement(String hook, List<? extends PrepareStatementSupplier> clauses, String separator, boolean useAlias) {
        return this.getPrepareStatement(hook, clauses, separator, "", useAlias);
    }

    default public void append(PrepareStatement prepareStatement, StringBuilder targetPrepareSql, List<ColumnValue> targetValues) {
        targetPrepareSql.append(prepareStatement.getPrepareSql());
        targetValues.addAll(prepareStatement.getValues());
    }

    default public void append(List<PrepareStatement> prepareStatements, StringBuilder targetPrepareSql, List<ColumnValue> targetValues) {
        prepareStatements.forEach(prepareStatement -> this.append((PrepareStatement)prepareStatement, targetPrepareSql, targetValues));
    }
}

