/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.CriteriaMaker;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.ValuesSupport;
import tech.ibit.sqlbuilder.sql.support.impl.PrepareStatementBuildSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class ValuesSupportImpl<T>
implements SqlSupport<T>,
ValuesSupport<T>,
PrepareStatementBuildSupport {
    private final T sql;
    private final ListField<Column> column;
    private final ListField<Object> value;

    public ValuesSupportImpl(T sql) {
        this.sql = sql;
        this.column = new ListField();
        this.value = new ListField();
    }

    private ListField<Column> getColumn() {
        return this.column;
    }

    public ListField<Object> getValue() {
        return this.value;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T values(List<? extends ColumnValue> columnValues) {
        columnValues.forEach(this::values);
        return this.getSql();
    }

    @Override
    public T values(ColumnValue columnValue) {
        return this.values((Column)columnValue.getColumn(), columnValue.getValue());
    }

    @Override
    public T values(Column column, Object value) {
        this.getColumn().addItem(column);
        this.getValue().addItem(value);
        return this.getSql();
    }

    @Override
    public T values(List<Column> columns, List<Object> values) {
        this.getColumn().addItems(columns);
        this.getValue().addItems(values);
        return this.getSql();
    }

    public PrepareStatement getColumnPrepareStatement() {
        List<Column> columns = this.getColumn().getItems();
        if (CollectionUtils.isEmpty(columns)) {
            return PrepareStatement.empty();
        }
        return this.getPrepareStatement("(", columns, Column::getName, null, ", ", ")");
    }

    public PrepareStatement getValuePrepareStatement() {
        List<Column> columns = this.getColumn().getItems();
        if (CollectionUtils.isEmpty(columns)) {
            return PrepareStatement.empty();
        }
        List<Object> values = this.getValue().getItems();
        if (CollectionUtils.isEmpty(values)) {
            return PrepareStatement.empty();
        }
        int columnSize = columns.size();
        int valueSize = values.size();
        List<String> valuesIns = this.getValueIns(columnSize, valueSize);
        String prepareSql = " VALUES" + StringUtils.join(valuesIns, (String)", ");
        ArrayList<ColumnValue> columnValues = new ArrayList<ColumnValue>();
        for (int i = 0; i < valueSize; ++i) {
            columnValues.add(new ColumnValue(columns.get(i % columnSize), values.get(i)));
        }
        return new PrepareStatement(prepareSql, columnValues);
    }

    private List<String> getValueIns(int columnSize, int totalSize) {
        ArrayList<String> valueIns = new ArrayList<String>();
        int size = totalSize / columnSize;
        for (int i = 0; i < size; ++i) {
            valueIns.add("(" + CriteriaMaker.getIn(columnSize) + ")");
        }
        return valueIns;
    }
}

