/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.sql.support.impl;

import java.util.ArrayList;
import java.util.List;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.CriteriaItem;
import tech.ibit.sqlbuilder.PrepareStatement;
import tech.ibit.sqlbuilder.sql.field.ListField;
import tech.ibit.sqlbuilder.sql.support.SqlSupport;
import tech.ibit.sqlbuilder.sql.support.WhereSupport;
import tech.ibit.sqlbuilder.sql.support.impl.CriteriaSupportImpl;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class WhereSupportImpl<T>
extends CriteriaSupportImpl
implements SqlSupport<T>,
WhereSupport<T> {
    private final T sql;
    private final ListField<Criteria> where;

    public WhereSupportImpl(T sql) {
        this(sql, new ListField<Criteria>());
    }

    private WhereSupportImpl(T sql, ListField<Criteria> where) {
        this.sql = sql;
        this.where = where;
    }

    public <K> WhereSupportImpl<K> copy(K sql) {
        return new WhereSupportImpl<K>(sql, this.where.copy());
    }

    public ListField<Criteria> getWhere() {
        return this.where;
    }

    @Override
    public T getSql() {
        return this.sql;
    }

    @Override
    public T where(Criteria criteria) {
        this.getWhere().addItem(criteria);
        return this.getSql();
    }

    @Override
    public T where(List<Criteria> criterion) {
        this.getWhere().addItems(criterion);
        return this.getSql();
    }

    @Override
    public T andWhere(CriteriaItem item) {
        return this.where(item.and());
    }

    @Override
    public T andWhere(List<Criteria> criterion) {
        return this.where(Criteria.and(criterion));
    }

    @Override
    public T orWhere(CriteriaItem item) {
        return this.where(item.or());
    }

    @Override
    public T orWhere(List<Criteria> criterion) {
        return this.where(Criteria.or(criterion));
    }

    public PrepareStatement getWherePrepareStatement(boolean useAlias) {
        List<Criteria> criterion = this.getWhere().getItems();
        if (CollectionUtils.isEmpty(criterion)) {
            return PrepareStatement.empty();
        }
        StringBuilder prepareSql = new StringBuilder();
        ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
        prepareSql.append(" WHERE ");
        this.append(criterion, useAlias, prepareSql, values);
        return new PrepareStatement(prepareSql.toString(), values);
    }
}

