/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.MultiId;
import tech.ibit.sqlbuilder.SqlFactory;
import tech.ibit.sqlbuilder.Table;
import tech.ibit.sqlbuilder.converter.ColumnSetValue;
import tech.ibit.sqlbuilder.converter.EntityConverter;
import tech.ibit.sqlbuilder.converter.TableColumnInfo;
import tech.ibit.sqlbuilder.converter.TableColumnSetValues;
import tech.ibit.sqlbuilder.exception.SqlException;
import tech.ibit.sqlbuilder.sql.DeleteSql;
import tech.ibit.sqlbuilder.sql.InsertSql;
import tech.ibit.sqlbuilder.sql.QuerySql;
import tech.ibit.sqlbuilder.sql.UpdateSql;
import tech.ibit.sqlbuilder.sql.support.SetSupport;
import tech.ibit.sqlbuilder.sql.support.WhereSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;

public class IdSqlUtils {
    private IdSqlUtils() {
    }

    public static <T, K> QuerySql getByIds(Class<T> poClazz, Collection<K> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo table = IdSqlUtils.getAndCheckTableIdInfo(poClazz);
        if (table.getIds().size() > 1) {
            throw SqlException.multiIdNotSupported(table.getTable().getName());
        }
        return IdSqlUtils.getByIds(table, idValues);
    }

    public static <T, K> QuerySql getById(Class<T> poClazz, K idValue) {
        return IdSqlUtils.getByIds(poClazz, null == idValue ? null : Collections.singletonList(idValue));
    }

    private static QuerySql getByIds(TableColumnInfo table, Collection<?> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        Column id = table.getIds().get(0);
        return (QuerySql)((QuerySql)((QuerySql)((QuerySql)SqlFactory.createQuery().column(table.getColumns())).from(table.getTable())).andWhere(id.in(idValues))).limit(idValues.size());
    }

    public static <T, K extends MultiId> QuerySql getByMultiIds(Class<T> poClazz, Collection<K> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo table = IdSqlUtils.getAndCheckTableIdInfo(poClazz);
        List<Column> ids = table.getIds();
        List<TableColumnSetValues> idValueList = EntityConverter.getTableColumnValuesList(new ArrayList<K>(idValues), true);
        if (1 == ids.size()) {
            return IdSqlUtils.getByIds(table, IdSqlUtils.getIdValues(ids.get(0), idValueList));
        }
        QuerySql sql = (QuerySql)((QuerySql)((QuerySql)SqlFactory.createQuery().column(table.getColumns())).from(table.getTable())).limit(idValues.size());
        IdSqlUtils.appendWhereSql(idValueList, sql);
        return sql;
    }

    public static <T, K extends MultiId> QuerySql getByMultiId(Class<T> poClazz, K idValue) {
        return IdSqlUtils.getByMultiIds(poClazz, null == idValue ? null : Collections.singletonList(idValue));
    }

    public static <T, K> DeleteSql deleteByIds(Class<T> poClazz, Collection<K> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo tableIdInfo = IdSqlUtils.getAndCheckTableIdInfo(poClazz);
        if (tableIdInfo.getIds().size() > 1) {
            throw SqlException.multiIdNotSupported(tableIdInfo.getTable().getName());
        }
        Column id = tableIdInfo.getIds().get(0);
        return (DeleteSql)SqlFactory.createDelete().deleteFrom(tableIdInfo.getTable()).andWhere(id.in(idValues));
    }

    public static <T, K> DeleteSql deleteById(Class<T> poClazz, K idValue) {
        return IdSqlUtils.deleteByIds(poClazz, null == idValue ? null : Collections.singletonList(idValue));
    }

    public static <K extends MultiId> DeleteSql deleteByMultiIds(Collection<K> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        List<TableColumnSetValues> idValueList = EntityConverter.getTableColumnValuesList(idValues, true);
        TableColumnSetValues firstIdValues = idValueList.get(0);
        if (firstIdValues.getColumnValues().isEmpty()) {
            throw SqlException.idNotFound(firstIdValues.getTable().getName());
        }
        DeleteSql sql = SqlFactory.createDelete().deleteFrom(firstIdValues.getTable());
        IdSqlUtils.appendWhereSql(idValueList, sql);
        return sql;
    }

    public static <K extends MultiId> DeleteSql deleteByMultiId(K idValue) {
        return IdSqlUtils.deleteByMultiIds(null == idValue ? null : Collections.singletonList(idValue));
    }

    public static <T> InsertSql insertInto(T po) {
        TableColumnSetValues entity = EntityConverter.getTableColumnValues(po, true);
        if (entity.getColumnValues().isEmpty()) {
            throw SqlException.columnValueNotFound();
        }
        List<ColumnSetValue> columnValues2Insert = IdSqlUtils.getFilterColumnSetValues(entity.getColumnValues());
        if (columnValues2Insert.isEmpty()) {
            throw SqlException.columnValueNotFound();
        }
        return (InsertSql)((InsertSql)SqlFactory.createInsert().insert(entity.getTable())).values(columnValues2Insert);
    }

    private static List<ColumnSetValue> getFilterColumnSetValues(List<ColumnSetValue> columnSetValues) {
        ArrayList<ColumnSetValue> columnValues2Insert = new ArrayList<ColumnSetValue>();
        columnSetValues.forEach(columnSetValue -> {
            Column column = (Column)columnSetValue.getColumn();
            Object value = columnSetValue.getValue();
            if (null != value) {
                if (columnSetValue.isAutoIncrease()) {
                    throw SqlException.idAutoIncrease(column.getTable().getName(), column.getName());
                }
                columnValues2Insert.add((ColumnSetValue)columnSetValue);
            } else if (IdSqlUtils.isColumnNotNullable(columnSetValue)) {
                throw SqlException.columnNullPointer(column.getTable().getName(), column.getName());
            }
        });
        return columnValues2Insert;
    }

    private static boolean isColumnNotNullable(ColumnSetValue columnSetValue) {
        return !columnSetValue.isAutoIncrease() && !columnSetValue.isNullable();
    }

    public static <T> InsertSql batchInsertInto(List<T> pos, List<Column> columns) {
        BatchInsertItems batchInsertItems = IdSqlUtils.getBatchInsertItems(pos, columns);
        return (InsertSql)((InsertSql)SqlFactory.createInsert().insert(batchInsertItems.getTable())).values(batchInsertItems.getColumns(), batchInsertItems.getValues());
    }

    public static <T> UpdateSql updateById(T updateObject) {
        return IdSqlUtils.updateById(updateObject, null);
    }

    public static <T> UpdateSql updateById(T updateObject, List<Column> updateColumns) {
        TableColumnInfo idEntity = IdSqlUtils.getAndCheckTableIdInfo(updateObject.getClass());
        if (null != updateColumns) {
            if (updateColumns.isEmpty()) {
                throw SqlException.columnValueNotFound();
            }
            LinkedHashSet<Column> updateColumnSet = new LinkedHashSet<Column>(updateColumns);
            updateColumnSet.addAll(idEntity.getIds());
            updateColumns = new ArrayList<Column>(updateColumnSet);
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        IdSqlUtils.checkIdNotNull(idEntity.getIds(), tableColumnValues.getColumnValues());
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate().update(idEntity.getTable());
        for (ColumnSetValue cv : tableColumnValues.getColumnValues()) {
            Column column = (Column)cv.getColumn();
            Object value = cv.getValue();
            if (cv.isId()) {
                if (null == value) {
                    throw SqlException.idNullPointer(idEntity.getTable().getName(), column.getName());
                }
                sql.andWhere(column.eq(value));
                continue;
            }
            if (!cv.isNullable() && null == value) {
                throw SqlException.columnNullPointer(idEntity.getTable().getName(), column.getName());
            }
            sql.set(column.set(value));
        }
        return sql;
    }

    public static <T, K> UpdateSql updateByIds(T updateObject, Collection<K> idValues) {
        return IdSqlUtils.updateByIds(updateObject, null, idValues);
    }

    public static <T, K> UpdateSql updateByIds(T updateObject, List<Column> updateColumns, Collection<K> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        TableColumnInfo idEntity = IdSqlUtils.getAndCheckTableIdInfo(updateObject.getClass());
        if (idEntity.getIds().size() > 1) {
            throw SqlException.multiIdNotSupported(idEntity.getTable().getName());
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate().update(tableColumnValues.getTable());
        IdSqlUtils.addSetsSql(tableColumnValues, sql);
        sql.andWhere(idEntity.getIds().get(0).in(idValues));
        return sql;
    }

    public static <T, K extends MultiId> UpdateSql updateByMultiIds(T updateObject, Collection<K> idValues) {
        return IdSqlUtils.updateByMultiIds(updateObject, null, idValues);
    }

    public static <T, K extends MultiId> UpdateSql updateByMultiIds(T updateObject, List<Column> updateColumns, Collection<K> idValues) {
        if (CollectionUtils.isEmpty(idValues)) {
            throw SqlException.idValueNotFound();
        }
        List<TableColumnSetValues> idValueList = EntityConverter.getTableColumnValuesList(new ArrayList<K>(idValues), true);
        TableColumnSetValues firstIdValues = idValueList.get(0);
        Table table = firstIdValues.getTable();
        if (firstIdValues.getColumnValues().isEmpty()) {
            throw SqlException.idNotFound(table.getName());
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate().update(table);
        IdSqlUtils.addSetsSql(tableColumnValues, sql);
        IdSqlUtils.appendWhereSql(idValueList, sql);
        return sql;
    }

    private static void checkIdNotNull(List<Column> ids, List<ColumnSetValue> columnSetValues) {
        LinkedHashMap idValueMap = new LinkedHashMap();
        ids.forEach(id -> idValueMap.put(id.getNameWithTableAlias(), null));
        columnSetValues.forEach(columnSetValue -> {
            String columnAlias = columnSetValue.getColumn().getNameWithTableAlias();
            if (idValueMap.containsKey(columnAlias)) {
                idValueMap.put(columnAlias, columnSetValue.getValue());
            }
        });
        for (Column id2 : ids) {
            if (null != idValueMap.get(id2.getNameWithTableAlias())) continue;
            throw SqlException.idNullPointer(id2.getTable().getName(), id2.getName());
        }
    }

    public static void addSetsSql(TableColumnSetValues tableColumnValues, SetSupport<?> sql) {
        for (ColumnSetValue cv : tableColumnValues.getColumnValues()) {
            Column column = (Column)cv.getColumn();
            Object value = cv.getValue();
            if (cv.isId()) {
                throw SqlException.idInvalidUpdate(((Column)cv.getColumn()).getTable().getName(), column.getName());
            }
            if (!cv.isNullable() && null == value) {
                throw SqlException.columnNullPointer(((Column)cv.getColumn()).getTable().getName(), column.getName());
            }
            sql.set(column.set(value));
        }
    }

    private static List<Object> getIdValues(Column id, List<TableColumnSetValues> columnValuesList) {
        ArrayList<Object> idValues = new ArrayList<Object>(columnValuesList.size());
        for (TableColumnSetValues columnValues : columnValuesList) {
            for (ColumnValue columnValue : columnValues.getColumnValues()) {
                if (!columnValue.getColumn().equals(id)) continue;
                idValues.add(columnValue.getValue());
            }
        }
        return idValues;
    }

    private static void appendWhereSql(List<TableColumnSetValues> columnValuesList, WhereSupport<?> sql) {
        if (columnValuesList.size() == 1) {
            List<ColumnSetValue> cvs = columnValuesList.get(0).getColumnValues();
            if (CollectionUtils.isNotEmpty(cvs)) {
                cvs.stream().filter(Objects::nonNull).forEach(cv -> sql.andWhere(null == cv.getValue() ? ((Column)cv.getColumn()).isNull() : ((Column)cv.getColumn()).eq(cv.getValue())));
            }
            return;
        }
        TableColumnSetValues firstIdValues = columnValuesList.get(0);
        if (firstIdValues.getColumnValues().size() == 1) {
            Column id = (Column)firstIdValues.getColumnValues().get(0).getColumn();
            List<Object> values = IdSqlUtils.getIdValues(id, columnValuesList);
            sql.andWhere(values.size() == 1 ? (null == values.get(0) ? id.isNull() : id.eq(values.get(0))) : id.in(values));
            return;
        }
        for (TableColumnSetValues columnValues : columnValuesList) {
            List<ColumnSetValue> cvs = columnValues.getColumnValues();
            if (!CollectionUtils.isNotEmpty(cvs)) continue;
            List items = cvs.stream().filter(Objects::nonNull).map(cv -> null == cv.getValue() ? ((Column)cv.getColumn()).isNull() : ((Column)cv.getColumn()).eq(cv.getValue())).collect(Collectors.toList());
            sql.orWhere(Criteria.ands(items));
        }
    }

    private static <T> TableColumnInfo getAndCheckTableIdInfo(Class<T> poClazz) {
        TableColumnInfo table = EntityConverter.getTableColumns(poClazz);
        if (CollectionUtils.isEmpty(table.getIds())) {
            throw SqlException.idNotFound(table.getTable().getName());
        }
        return table;
    }

    private static BatchInsertItems getBatchInsertItems(List<?> objs, List<Column> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            throw SqlException.columnValueNotFound();
        }
        Set filterColumnSet = columns.stream().map(Column::getNameWithTableAlias).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList<Object> values = new ArrayList<Object>(objs.size() * columns.size());
        Table table = null;
        for (Object obj : objs) {
            TableColumnSetValues entity = EntityConverter.getTableColumnValues(obj, true);
            if (null == table) {
                table = entity.getTable();
            } else if (!table.equals(entity.getTable())) {
                throw SqlException.tableNotMatched(table.getName(), entity.getTable().getName());
            }
            List<ColumnSetValue> columnValues2Insert = IdSqlUtils.getFilterColumnSetValues(entity.getColumnValues(), filterColumnSet);
            columnValues2Insert.forEach(columnValue -> values.add(columnValue.getValue()));
        }
        return new BatchInsertItems(table, columns, values);
    }

    private static List<ColumnSetValue> getFilterColumnSetValues(List<ColumnSetValue> columnSetValues, Set<String> filterColumnSet) {
        HashMap columnSetValueMap = new HashMap();
        columnSetValues.forEach(columnSetValue -> {
            Column column = (Column)columnSetValue.getColumn();
            String columnNameWithTableAlias = column.getNameWithTableAlias();
            Object value = columnSetValue.getValue();
            if (filterColumnSet.contains(columnNameWithTableAlias)) {
                if (null != value) {
                    if (columnSetValue.isAutoIncrease()) {
                        throw SqlException.idAutoIncrease(column.getTable().getName(), column.getName());
                    }
                } else if (IdSqlUtils.isColumnNotNullable(columnSetValue)) {
                    throw SqlException.columnNullPointer(column.getTable().getName(), column.getName());
                }
                columnSetValueMap.put(columnNameWithTableAlias, columnSetValue);
            } else if (IdSqlUtils.isColumnNotNullable(columnSetValue)) {
                throw SqlException.columnNullPointer(column.getTable().getName(), column.getName());
            }
        });
        ArrayList<ColumnSetValue> columnValues2Insert = new ArrayList<ColumnSetValue>();
        filterColumnSet.forEach(column -> columnValues2Insert.add((ColumnSetValue)columnSetValueMap.get(column)));
        return columnValues2Insert;
    }

    private static class BatchInsertItems {
        private final Table table;
        private final List<Column> columns;
        private final List<Object> values;

        public BatchInsertItems(Table table, List<Column> columns, List<Object> values) {
            this.table = table;
            this.columns = columns;
            this.values = values;
        }

        public Table getTable() {
            return this.table;
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public List<Object> getValues() {
            return this.values;
        }
    }
}

