/*
 * Decompiled with CFR 0.152.
 */
package tech.ibit.sqlbuilder.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import tech.ibit.sqlbuilder.Column;
import tech.ibit.sqlbuilder.ColumnValue;
import tech.ibit.sqlbuilder.Criteria;
import tech.ibit.sqlbuilder.SqlFactory;
import tech.ibit.sqlbuilder.UniqueKey;
import tech.ibit.sqlbuilder.converter.EntityConverter;
import tech.ibit.sqlbuilder.converter.TableColumnInfo;
import tech.ibit.sqlbuilder.converter.TableColumnSetValues;
import tech.ibit.sqlbuilder.exception.SqlException;
import tech.ibit.sqlbuilder.sql.DeleteSql;
import tech.ibit.sqlbuilder.sql.QuerySql;
import tech.ibit.sqlbuilder.sql.UpdateSql;
import tech.ibit.sqlbuilder.sql.support.WhereSupport;
import tech.ibit.sqlbuilder.utils.CollectionUtils;
import tech.ibit.sqlbuilder.utils.IdSqlUtils;

public class UniqueKeySqlUtils {
    private UniqueKeySqlUtils() {
    }

    public static <T> QuerySql getByUniqueKey(Class<T> poClazz, UniqueKey uniqueKey) {
        return UniqueKeySqlUtils.getByUniqueKeys(poClazz, null == uniqueKey ? null : Collections.singleton(uniqueKey));
    }

    public static <T> QuerySql getByUniqueKeys(Class<?> poClazz, Collection<UniqueKey> uniqueKeys) {
        if (CollectionUtils.isEmpty(uniqueKeys)) {
            throw SqlException.uniqueKeyValueNotFound();
        }
        TableColumnInfo table = EntityConverter.getTableColumns(poClazz);
        QuerySql sql = (QuerySql)((QuerySql)((QuerySql)SqlFactory.createQuery().from(table.getTable())).column(table.getColumns())).limit(uniqueKeys.size());
        UniqueKeySqlUtils.addWhere(sql, uniqueKeys);
        return sql;
    }

    public static <T> DeleteSql deleteByUniqueKeys(Class<T> poClazz, Collection<UniqueKey> uniqueKeys) {
        if (CollectionUtils.isEmpty(uniqueKeys)) {
            throw SqlException.uniqueKeyValueNotFound();
        }
        TableColumnInfo table = EntityConverter.getTableColumns(poClazz);
        DeleteSql sql = SqlFactory.createDelete().deleteFrom(table.getTable());
        UniqueKeySqlUtils.addWhere(sql, uniqueKeys);
        return sql;
    }

    public static <T> DeleteSql deleteByUniqueKey(Class<T> poClazz, UniqueKey uniqueKey) {
        return UniqueKeySqlUtils.deleteByUniqueKeys(poClazz, null == uniqueKey ? null : Collections.singletonList(uniqueKey));
    }

    public static <T> UpdateSql updateByUniqueKeys(T updateObject, Collection<UniqueKey> idValues) {
        return UniqueKeySqlUtils.updateByUniqueKeys(updateObject, null, idValues);
    }

    public static <T> UpdateSql updateByUniqueKeys(T updateObject, List<Column> updateColumns, Collection<UniqueKey> uniqueKeys) {
        if (CollectionUtils.isEmpty(uniqueKeys)) {
            throw SqlException.uniqueKeyValueNotFound();
        }
        TableColumnSetValues tableColumnValues = null == updateColumns ? EntityConverter.getTableColumnValues(updateObject, false) : EntityConverter.getTableColumnValues(updateObject, updateColumns);
        UpdateSql sql = (UpdateSql)SqlFactory.createUpdate().update(tableColumnValues.getTable());
        IdSqlUtils.addSetsSql(tableColumnValues, sql);
        UniqueKeySqlUtils.addWhere(sql, uniqueKeys);
        return sql;
    }

    private static void addWhere(WhereSupport<?> sql, Collection<UniqueKey> uniqueKeys) {
        Column uniqueColumn = UniqueKeySqlUtils.getCheckUniqueColumn(uniqueKeys);
        if (null != uniqueColumn) {
            HashSet values = new HashSet(uniqueKeys.size());
            uniqueKeys.forEach(uniqueKey -> values.add(uniqueKey.getColumnValues().get(0).getValue()));
            sql.andWhere(uniqueColumn.in(values));
            return;
        }
        if (uniqueKeys.size() == 1) {
            UniqueKey uniqueKey2 = uniqueKeys.stream().findFirst().get();
            List<ColumnValue> columnValues = uniqueKey2.getColumnValues();
            columnValues.forEach(columnValue -> {
                Column column = (Column)columnValue.getColumn();
                Object value = columnValue.getValue();
                sql.andWhere(column.eq(value));
            });
            return;
        }
        uniqueKeys.forEach(uniqueKey -> {
            List<ColumnValue> columnValues = uniqueKey.getColumnValues();
            List items = columnValues.stream().map(columnValue -> {
                Column column = (Column)columnValue.getColumn();
                Object value = columnValue.getValue();
                return column.eq(value);
            }).collect(Collectors.toList());
            sql.orWhere(Criteria.ands(items));
        });
    }

    private static Column getCheckUniqueColumn(Collection<UniqueKey> uniqueKeys) {
        Column column = null;
        for (UniqueKey uniqueKey : uniqueKeys) {
            if (null == uniqueKey || CollectionUtils.isEmpty(uniqueKey.getColumnValues())) {
                throw SqlException.uniqueKeyValueNotFound();
            }
            if (uniqueKey.getColumnValues().size() > 1) {
                return null;
            }
            Column firstColumn = (Column)uniqueKey.getColumnValues().get(0).getColumn();
            if (null == column) {
                column = firstColumn;
                continue;
            }
            if (column.equals(firstColumn)) continue;
            return null;
        }
        return column;
    }
}

