/*
 * Decompiled with CFR 0.152.
 */
package tech.iboot.commons.quartz.service;

import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Scheduler scheduler;

    public void addJob(String name, String group, Class<? extends Job> clazz, String time) throws Exception {
        JobKey jobKey = new JobKey(name, group);
        if (this.checkExists(jobKey)) {
            this.logger.info("Job name is {} group is {} is existed", (Object)name, (Object)group);
        } else {
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)time);
            JobDetail jobDetail = JobBuilder.newJob(clazz).withIdentity(name, group).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, group).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
    }

    public void pauseJob(String name, String group) throws SchedulerException {
        JobKey jobKey = new JobKey(name, group);
        if (this.checkExists(jobKey)) {
            this.scheduler.pauseJob(jobKey);
            this.logger.info("pause Job name is {} group is pauseJob {} success", (Object)name, (Object)group);
        } else {
            this.logger.info("Job name is {} group is {} doesn't exist", (Object)name, (Object)group);
        }
    }

    public void resumeJob(String name, String group) throws SchedulerException {
        JobKey jobKey = new JobKey(name, group);
        if (this.checkExists(jobKey)) {
            this.scheduler.resumeJob(jobKey);
            this.logger.info("pause Job name is {} group is  resumeJob {} success", (Object)name, (Object)group);
        } else {
            this.logger.info("Job name is {} group is {} doesn't exist", (Object)name, (Object)group);
        }
    }

    public void modifyJobTime(String name, String group, Class<? extends Job> clazz, String newTime) throws Exception {
        JobKey jobKey = new JobKey(name, group);
        this.deleteJob(jobKey);
        this.addJob(name, group, clazz, newTime);
    }

    public void deleteJob(String name, String group) throws SchedulerException {
        JobKey jobKey = new JobKey(name, group);
        if (this.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
            this.logger.info("pause Job name is {} group is  deleteJob {} success", (Object)name, (Object)group);
        } else {
            this.logger.info("Job name is {} group is {} doesn't exist", (Object)name, (Object)group);
        }
    }

    public void deleteJob(JobKey jobKey) throws SchedulerException {
        if (this.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
            this.logger.info("pause Job name is {} group is  deleteJob {} success", (Object)jobKey.getName(), (Object)jobKey.getGroup());
        } else {
            this.logger.info("Job name is {} group is {} doesn't exist", (Object)jobKey.getName(), (Object)jobKey.getGroup());
        }
    }

    public boolean checkExists(String name, String group) throws SchedulerException {
        JobKey jobKey = new JobKey(name, group);
        return this.checkExists(jobKey);
    }

    public boolean checkExists(JobKey jobKey) throws SchedulerException {
        return this.scheduler.checkExists(jobKey);
    }
}

