/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.test;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

@ConditionalOnClass(value={LoggerContext.class})
public class LogbackRecorder {
    public static final boolean DEFAULT_MUTE = true;
    public static final String DEFAULT_LEVEL = "ALL";
    public static final String LOGBACK_EXCEPTION_MESSAGE = "Expected logback";
    public static final String CAPTURE_EXCEPTION_MESSAGE = "Already capturing";
    public static final String RELEASE_EXCEPTION_MESSAGE = "Not currently capturing";
    private static final LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static final Object lock = context.getConfigurationLock();
    private static final Map<ch.qos.logback.classic.Logger, LogbackRecorder> instances = new WeakHashMap<ch.qos.logback.classic.Logger, LogbackRecorder>(32, 0.75f);
    private final ch.qos.logback.classic.Logger logger;
    private final List<Event> events;
    private final AppenderBase<ILoggingEvent> appender;
    private boolean active;
    private boolean additive;
    private Level level;

    public static final LogbackRecorder forClass(Class<?> clazz) {
        return LogbackRecorder.forLogger((Logger)context.getLogger(clazz));
    }

    public static final LogbackRecorder forName(String name) {
        return LogbackRecorder.forLogger((Logger)context.getLogger(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LogbackRecorder forLogger(Logger logger) {
        Map<ch.qos.logback.classic.Logger, LogbackRecorder> map = instances;
        synchronized (map) {
            if (!(logger instanceof ch.qos.logback.classic.Logger)) {
                throw new IllegalArgumentException(LOGBACK_EXCEPTION_MESSAGE);
            }
            LogbackRecorder recorder = instances.get(logger);
            if (recorder == null) {
                recorder = new LogbackRecorder((ch.qos.logback.classic.Logger)logger);
                instances.put(recorder.logger, recorder);
            }
            return recorder;
        }
    }

    private LogbackRecorder(ch.qos.logback.classic.Logger logger) {
        this.logger = logger;
        this.events = new ArrayList<Event>();
        this.appender = new AppenderBase<ILoggingEvent>(){

            protected synchronized void append(ILoggingEvent event) {
                LogbackRecorder.this.events.add(new Event(event));
            }
        };
    }

    public synchronized LogbackRecorder reset() {
        this.events.clear();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogbackRecorder capture(String level) {
        Object object = lock;
        synchronized (object) {
            if (this.active) {
                throw new IllegalStateException(CAPTURE_EXCEPTION_MESSAGE);
            }
            this.active = true;
            this.additive = this.logger.isAdditive();
            this.logger.setAdditive(false);
            this.level = this.logger.getLevel();
            this.logger.setLevel(Level.valueOf((String)level.toUpperCase()));
            this.logger.addAppender(this.appender);
            this.appender.start();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LogbackRecorder release() {
        Object object = lock;
        synchronized (object) {
            if (!this.active) {
                throw new IllegalStateException(RELEASE_EXCEPTION_MESSAGE);
            }
            this.appender.stop();
            this.logger.detachAppender(this.appender);
            this.logger.setLevel(this.level);
            this.logger.setAdditive(this.additive);
        }
        this.active = false;
        return this;
    }

    public List<Event> play() {
        return new ArrayList<Event>(this.events);
    }

    public static final class Event {
        private final Marker marker;
        private final String level;
        private final String message;
        private final Object[] arguments;
        private final String thrown;

        Event(ILoggingEvent event) {
            this.marker = event.getMarker();
            this.level = event.getLevel().toString();
            this.message = event.getMessage();
            this.arguments = event.getArgumentArray();
            IThrowableProxy proxy = event.getThrowableProxy();
            this.thrown = proxy == null ? null : proxy.getClassName() + ": " + proxy.getMessage();
        }

        public Marker getMarker() {
            return this.marker;
        }

        public String getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public String getThrown() {
            return this.thrown;
        }
    }
}

