/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.apidoc.customizer;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.core.Ordered;
import tech.jhipster.config.JHipsterProperties;

public class JHipsterOpenApiCustomizer
implements OpenApiCustomiser,
Ordered {
    public static final int DEFAULT_ORDER = 0;
    private int order = 0;
    private final JHipsterProperties.ApiDocs properties;

    public JHipsterOpenApiCustomizer(JHipsterProperties.ApiDocs properties) {
        this.properties = properties;
    }

    public void customise(OpenAPI openAPI) {
        Contact contact = new Contact().name(this.properties.getContactName()).url(this.properties.getContactUrl()).email(this.properties.getContactEmail());
        openAPI.info(new Info().contact(contact).title(this.properties.getTitle()).description(this.properties.getDescription()).version(this.properties.getVersion()).termsOfService(this.properties.getTermsOfServiceUrl()).license(new License().name(this.properties.getLicense()).url(this.properties.getLicenseUrl())));
        for (JHipsterProperties.ApiDocs.Server server : this.properties.getServers()) {
            openAPI.addServersItem(new Server().url(server.getUrl()).description(server.getDescription()));
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }
}

