/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.locale;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.util.WebUtils;

public class AngularCookieLocaleResolver
extends CookieLocaleResolver {
    private final Logger logger = LoggerFactory.getLogger(AngularCookieLocaleResolver.class);
    public static final String QUOTE = "%22";
    private final Function<HttpServletRequest, Locale> defaultLocaleFunction = request -> {
        Locale defaultLocale = this.getDefaultLocale();
        return defaultLocale != null ? defaultLocale : request.getLocale();
    };
    private final Function<HttpServletRequest, TimeZone> defaultTimeZoneFunction = request -> this.getDefaultTimeZone();

    public AngularCookieLocaleResolver() {
    }

    public AngularCookieLocaleResolver(String cookieName) {
        super(cookieName);
    }

    public Locale resolveLocale(HttpServletRequest request) {
        this.parseAngularCookieIfNecessary(request);
        return (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
    }

    public LocaleContext resolveLocaleContext(final HttpServletRequest request) {
        this.parseAngularCookieIfNecessary(request);
        return new TimeZoneAwareLocaleContext(){

            public Locale getLocale() {
                return (Locale)request.getAttribute(CookieLocaleResolver.LOCALE_REQUEST_ATTRIBUTE_NAME);
            }

            public TimeZone getTimeZone() {
                return (TimeZone)request.getAttribute(CookieLocaleResolver.TIME_ZONE_REQUEST_ATTRIBUTE_NAME);
            }
        };
    }

    private void parseAngularCookieIfNecessary(HttpServletRequest request) {
        Cookie cookie;
        LocaleAndTimeZone localeAndTimeZone = null;
        if (request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME) == null && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)DEFAULT_COOKIE_NAME)) != null) {
            localeAndTimeZone = this.parseCookie(cookie);
        }
        if (localeAndTimeZone == null) {
            localeAndTimeZone = new LocaleAndTimeZone(null, null);
        }
        request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)(localeAndTimeZone.locale != null ? localeAndTimeZone.locale : this.defaultLocaleFunction.apply(request)));
        request.setAttribute(TIME_ZONE_REQUEST_ATTRIBUTE_NAME, (Object)(localeAndTimeZone.timeZone != null ? localeAndTimeZone.timeZone : this.defaultTimeZoneFunction.apply(request)));
    }

    private LocaleAndTimeZone parseCookie(Cookie cookie) {
        TimeZone timeZone;
        String value;
        String localePart = value = StringUtils.replace((String)cookie.getValue(), (String)QUOTE, (String)"");
        String timeZonePart = null;
        int spaceIndex = localePart.indexOf(32);
        if (spaceIndex != -1) {
            localePart = value.substring(0, spaceIndex);
            timeZonePart = value.substring(spaceIndex + 1);
        }
        Locale locale = !"-".equals(localePart) ? StringUtils.parseLocaleString((String)localePart.replace('-', '_')) : null;
        TimeZone timeZone2 = timeZone = timeZonePart != null ? StringUtils.parseTimeZoneString(timeZonePart) : null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Parsed cookie value [" + cookie.getValue() + "] into locale '" + String.valueOf(locale) + "'" + (String)(timeZone != null ? " and time zone '" + timeZone.getID() + "'" : ""));
        }
        return new LocaleAndTimeZone(locale, timeZone);
    }

    String quote(String string) {
        return QUOTE + string + QUOTE;
    }

    private record LocaleAndTimeZone(Locale locale, TimeZone timeZone) {
    }
}

