/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.cache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.cache.interceptor.KeyGenerator;
import tech.jhipster.config.cache.PrefixedSimpleKey;

public class PrefixedKeyGenerator
implements KeyGenerator {
    private final String prefix;
    private String shortCommitId = null;
    private Instant time = null;
    private String version = null;

    public PrefixedKeyGenerator(GitProperties gitProperties, BuildProperties buildProperties) {
        this.prefix = this.generatePrefix(gitProperties, buildProperties);
    }

    String getPrefix() {
        return this.prefix;
    }

    private String generatePrefix(GitProperties gitProperties, BuildProperties buildProperties) {
        Object p;
        if (Objects.nonNull(gitProperties)) {
            this.shortCommitId = gitProperties.getShortCommitId();
        }
        if (Objects.nonNull(buildProperties)) {
            this.time = buildProperties.getTime();
            this.version = buildProperties.getVersion();
        }
        if ((p = ObjectUtils.firstNonNull((Object[])new Serializable[]{this.shortCommitId, this.time, this.version, RandomStringUtils.randomAlphanumeric((int)12)})) instanceof Instant) {
            return DateTimeFormatter.ISO_INSTANT.format((Instant)p);
        }
        return p.toString();
    }

    public Object generate(Object target, Method method, Object ... params) {
        return new PrefixedSimpleKey(this.prefix, method.getName(), params);
    }
}

