/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.buildtool.maven.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class MavenModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("buildtool/maven");
    private static final GroupId APACHE_PLUGINS_GROUP = JHipsterModule.groupId("org.apache.maven.plugins");
    private static final ArtifactId ENFORCER_ARTIFACTID = JHipsterModule.artifactId("maven-enforcer-plugin");
    private static final String JAVA_PREREQUISITES = "\n### Java\n\nYou need to have Java 21:\n- [JDK 21](https://openjdk.java.net/projects/jdk/21/)";

    public JHipsterModule buildMavenModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).and().prerequisites(JAVA_PREREQUISITES).gitIgnore().comment("Maven").pattern("/target/").and().files().add(SOURCE.template("pom.xml"), JHipsterModule.to("pom.xml")).and().javaDependencies().addDependency(MavenModuleFactory.junitEngineDependency()).addDependency(MavenModuleFactory.junitParamsDependency()).addDependency(MavenModuleFactory.assertjDependency()).addDependency(MavenModuleFactory.mockitoDependency()).and().mavenPlugins().plugin(this.mavenCompilerPlugin()).plugin(this.surefirePlugin()).plugin(this.failsafePlugin()).plugin(this.enforcerPlugin()).pluginManagement(this.enforcerPluginManagement()).and().build();
    }

    private static JavaDependency junitEngineDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.jupiter").artifactId("junit-jupiter-engine").versionSlug("junit-jupiter.version").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency junitParamsDependency() {
        return JHipsterModule.javaDependency().groupId("org.junit.jupiter").artifactId("junit-jupiter-params").versionSlug("junit-jupiter.version").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency assertjDependency() {
        return JHipsterModule.javaDependency().groupId("org.assertj").artifactId("assertj-core").versionSlug("assertj.version").scope(JavaDependencyScope.TEST).build();
    }

    private static JavaDependency mockitoDependency() {
        return JHipsterModule.javaDependency().groupId("org.mockito").artifactId("mockito-junit-jupiter").versionSlug("mockito.version").scope(JavaDependencyScope.TEST).build();
    }

    public JHipsterModule buildMavenWrapperModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).gitIgnore().comment("Maven Wrapper").pattern("!.mvn/wrapper/maven-wrapper.jar").and().startupCommands().maven("").and().files().addExecutable(SOURCE.file("mvnw"), JHipsterModule.to("mvnw")).addExecutable(SOURCE.file("mvnw.cmd"), JHipsterModule.to("mvnw.cmd")).batch(SOURCE.append(".mvn/wrapper"), JHipsterModule.to(".mvn/wrapper")).addFile("maven-wrapper.jar").addFile("maven-wrapper.properties").and().and().build();
    }

    private MavenPlugin mavenCompilerPlugin() {
        return JHipsterModule.mavenPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-compiler-plugin").versionSlug("compiler-plugin").configuration("  <release>${java.version}</release>\n  <parameters>true</parameters>\n").build();
    }

    private MavenPlugin surefirePlugin() {
        return JHipsterModule.mavenPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-surefire-plugin").versionSlug("surefire-plugin").configuration("<!-- Force alphabetical order to have a reproducible build -->\n<runOrder>alphabetical</runOrder>\n<excludes>\n  <exclude>**/*IT*</exclude>\n  <exclude>**/*CucumberTest*</exclude>\n</excludes>\n").build();
    }

    private MavenPlugin failsafePlugin() {
        return JHipsterModule.mavenPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId("maven-failsafe-plugin").versionSlug("failsafe-plugin").configuration("  <!-- Due to spring-boot repackage, without adding this property test classes are not found\n         See https://github.com/spring-projects/spring-boot/issues/6254 -->\n  <classesDirectory>${project.build.outputDirectory}</classesDirectory>\n  <!-- Force alphabetical order to have a reproducible build -->\n  <runOrder>alphabetical</runOrder>\n  <includes>\n    <include>**/*IT*</include>\n    <include>**/*CucumberTest*</include>\n  </includes>\n").addExecution(JHipsterModule.pluginExecution().goals("integration-test").id("integration-test")).addExecution(JHipsterModule.pluginExecution().goals("verify").id("verify")).build();
    }

    private MavenPlugin enforcerPlugin() {
        return JHipsterModule.mavenPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId(ENFORCER_ARTIFACTID).build();
    }

    private MavenPlugin enforcerPluginManagement() {
        return JHipsterModule.mavenPlugin().groupId(APACHE_PLUGINS_GROUP).artifactId(ENFORCER_ARTIFACTID).versionSlug("maven-enforcer-plugin").addExecution(JHipsterModule.pluginExecution().goals("enforce").id("enforce-versions")).addExecution(JHipsterModule.pluginExecution().goals("enforce").id("enforce-dependencyConvergence").configuration("<rules>\n  <DependencyConvergence />\n</rules>\n<fail>false</fail>\n")).configuration("<rules>\n  <requireMavenVersion>\n    <message>You are running an older version of Maven: minimum required version is ${maven.version}</message>\n    <version>${maven.version}</version>\n  </requireMavenVersion>\n  <requireJavaVersion>\n    <message>You are running an incompatible version of Java: minimum required version is ${java.version}</message>\n    <version>${java.version}</version>\n  </requireJavaVersion>\n</rules>\n").build();
    }
}

