/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.angular.security.oauth2.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class AngularOauth2ModuleFactory {
    private static final Pattern PROVIDERS_PATTERN = Pattern.compile("(providers: *\\[)");
    private static final ElementReplacer EXISTING_PROVIDERS_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> PROVIDERS_PATTERN.matcher(contentBeforeReplacement).find(), PROVIDERS_PATTERN);
    private static final ElementReplacer ENVIRONMENT_NEEDLE = JHipsterModule.lineAfterRegex("export const environment *= *\\{");
    private static final String KEYCLOAK_ENVIRONMENT = "keycloak: {\n  url: 'http://localhost:9080',\n  realm: 'jhipster',\n  client_id: 'web_app',\n},\n";
    private static final Pattern EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN = Pattern.compile("(\"allowedCommonJsDependencies\": *\\[\\s*)\\]");
    private static final ElementReplacer EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN.matcher(contentBeforeReplacement).find(), EMPTY_ALLOWED_COMMON_DEPENDENCIES_PATTERN);
    private static final Pattern FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN = Pattern.compile("(\"allowedCommonJsDependencies\": *\\[[^]]+)\\]");
    private static final ElementReplacer FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN.matcher(contentBeforeReplacement).find(), FILLED_ALLOWED_COMMON_DEPENDENCIES_PATTERN);
    private static final Pattern FILLED_STANDALONE_PATTERN = Pattern.compile("(imports: *\\[[^]]+)\\]");
    private static final ElementReplacer FILLED_STANDALONE_NEEDLE = new RegexReplacer((contentBeforeReplacement, replacement) -> FILLED_STANDALONE_PATTERN.matcher(contentBeforeReplacement).find(), FILLED_STANDALONE_PATTERN);
    private static final ElementReplacer MENU_NEEDLE = JHipsterModule.lineAfterRegex("<span.+id=\\\"menu-space-separator\\\".*></span>");
    private static final String TEST_IMPORTS = "import { By } from '@angular/platform-browser';\nimport { Oauth2AuthService } from './auth/oauth2-auth.service';\nimport LoginComponent from './login/login.component';\n";
    private static final ElementReplacer TEST_NEEDLE = JHipsterModule.lineAfterRegex("^\\s+it\\('should have appName',[^}]+\\}\\);");
    private static final String LOGIN_IMPORT = "import LoginComponent from './login/login.component';\n";
    private static final String OAUTH2_AUTH_SERVICE_IMPORT = "import { Oauth2AuthService } from './auth/oauth2-auth.service';\n";
    private static final ElementReplacer APPNAME_NEEDLE = JHipsterModule.lineAfterRegex("appName = '';");
    private static final String INJECT_OAUTH2_AUTH_SERVICE = "  private oauth2AuthService = inject(Oauth2AuthService);";
    private static final String INIT_AUTHENTICATION = "    this.oauth2AuthService.initAuthentication();";
    private static final String INJECT_IMPORT = "import { Component, inject, OnInit } from '@angular/core';\n";
    private static final ElementReplacer INJECT_NEEDLE = JHipsterModule.text("import { Component, OnInit } from '@angular/core';");
    private static final ElementReplacer BEFORE_EACH_NEEDLE = JHipsterModule.lineAfterRegex("comp = fixture.componentInstance;");
    private static final String TESTBED_INJECT_OAUTH2_AUTH_SERVICE = "    oauth2AuthService = TestBed.inject(Oauth2AuthService);";
    private static final ElementReplacer TEST_APP_COMPONENT = JHipsterModule.lineAfterRegex("let comp: AppComponent;");
    private static final String DECLARE_INJECT_OAUTH2_AUTH_SERVICE = "  let oauth2AuthService: Oauth2AuthService;";
    private static final String LOGIN_COMPONENT_TEST = "\nit('should display login component', () => {\n  fixture.detectChanges();\n\n  expect(fixture.debugElement.query(By.directive(LoginComponent))).toBeTruthy();\n});\n";
    private static final String HTTP_AUTH_INTERCEPTOR_IMPORT = "import { HttpAuthInterceptor } from './app/auth/http-auth.interceptor';\n";
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/angular/security/oauth2/src/main/webapp/app");
    private static final JHipsterDestination APP_DESTINATION = JHipsterModule.to("src/main/webapp/app");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        Indentation indentation = properties.indentation();
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("keycloak-js"), VersionSource.ANGULAR).and().files().batch(SOURCE.append("auth"), APP_DESTINATION.append("auth")).addTemplate("oauth2-auth.service.ts").addTemplate("oauth2-auth.service.spec.ts").addTemplate("http-auth.interceptor.ts").addTemplate("http-auth.interceptor.spec.ts").and().batch(SOURCE.append("login"), APP_DESTINATION.append("login")).addTemplate("login.component.html").addTemplate("login.component.ts").addTemplate("login.component.spec.ts").and().and().mandatoryReplacements().in(JHipsterModule.path("src/main/webapp/environments/environment.ts")).add(ENVIRONMENT_NEEDLE, this.keycloakEnvironment(indentation))).and()).in(JHipsterModule.path("src/main/webapp/environments/environment.prod.ts")).add(ENVIRONMENT_NEEDLE, this.keycloakEnvironment(indentation))).and()).in(JHipsterModule.path("angular.json")).add(FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1, \"base64-js\"]")).add(EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1\"base64-js\"]")).add(FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1, \"js-sha256\"]")).add(EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1\"js-sha256\"]")).add(FILLED_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1, \"keycloak-js\"]")).add(EMPTY_ALLOWED_COMMON_DEPENDENCIES_NEEDLE, "$1\"keycloak-js\"]")).and()).in(JHipsterModule.path("src/main/webapp/main.ts")).add(EXISTING_PROVIDERS_NEEDLE, "providers: [{ provide: HTTP_INTERCEPTORS, useClass: HttpAuthInterceptor, multi: true },")).add(JHipsterModule.fileStart(), HTTP_AUTH_INTERCEPTOR_IMPORT)).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.ts")).add(FILLED_STANDALONE_NEEDLE, "$1, LoginComponent]")).add(JHipsterModule.fileStart(), OAUTH2_AUTH_SERVICE_IMPORT)).add(JHipsterModule.fileStart(), LOGIN_IMPORT)).add(INJECT_NEEDLE, INJECT_IMPORT)).add(APPNAME_NEEDLE, INJECT_OAUTH2_AUTH_SERVICE)).add(JHipsterModule.lineAfterRegex("this.appName = '" + properties.projectBaseName().name() + "';"), INIT_AUTHENTICATION)).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.spec.ts")).add(JHipsterModule.fileStart(), TEST_IMPORTS)).add(TEST_NEEDLE, LOGIN_COMPONENT_TEST.indent(indentation.spacesCount() * 2))).add(BEFORE_EACH_NEEDLE, TESTBED_INJECT_OAUTH2_AUTH_SERVICE)).add(TEST_APP_COMPONENT, DECLARE_INJECT_OAUTH2_AUTH_SERVICE)).and()).in(JHipsterModule.path("src/main/webapp/app/app.component.html")).add(MENU_NEEDLE, indentation.spaces() + "<jhi-login></jhi-login>")).and()).and().build();
    }

    private String keycloakEnvironment(Indentation indentation) {
        return KEYCLOAK_ENVIRONMENT.indent(indentation.spacesCount());
    }
}

