/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.tools.cypress.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.RegexReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CypressModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/common/cypress");
    private static final String CYPRESS_TEST = "src/test/javascript/integration";
    private static final JHipsterDestination CYPRESS_DESTINATION = JHipsterModule.to("src/test/javascript/integration");
    private static final String PRIMARY_APP = "common/primary/app";
    private static final String CYPRESS_EXCLUSION = "\"src/test/javascript/integration/**/*.ts\"";
    private static final String EXCLUDE_KEY = "\"exclude\"";
    private static final RegexReplacer NEW_EXCLUSION_REPLACER = new RegexReplacer((currentContent, replacement) -> !currentContent.contains(EXCLUDE_KEY), Pattern.compile("\\n.*\\}\\s*$"));
    private static final RegexReplacer EXISTING_EXCLUSION_REPLACER = new RegexReplacer((currentContent, replacement) -> currentContent.contains(EXCLUDE_KEY) && !currentContent.contains(CYPRESS_EXCLUSION), Pattern.compile("(\"exclude\"\\s*:\\s*\\[[^\\]]+)\\]"));
    private static final RegexReplacer EMPTY_EXCLUSION_REPLACER = new RegexReplacer((currentContent, replacement) -> currentContent.contains(EXCLUDE_KEY) && !currentContent.contains(CYPRESS_EXCLUSION), Pattern.compile("(\"exclude\"\\s*:\\s*\\[\\s*)\\]"));

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDevDependency(JHipsterModule.packageName("cypress"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("eslint-plugin-cypress"), VersionSource.COMMON).addScript(JHipsterModule.scriptKey("e2e"), JHipsterModule.scriptCommand("npm run test:component")).addScript(JHipsterModule.scriptKey("e2e:headless"), JHipsterModule.scriptCommand("npm run test:component:headless")).addScript(JHipsterModule.scriptKey("test:component"), JHipsterModule.scriptCommand("cypress open --config-file src/test/javascript/integration/cypress-config.ts")).addScript(JHipsterModule.scriptKey("test:component:headless"), JHipsterModule.scriptCommand("cypress run --headless --config-file src/test/javascript/integration/cypress-config.ts")).and().files().batch(SOURCE.append(CYPRESS_TEST), CYPRESS_DESTINATION).addFile("cypress-config.ts").addFile(".eslintrc.cjs").addFile("tsconfig.json").and().add(SOURCE.append(CYPRESS_TEST).append(PRIMARY_APP).file("Home.spec.ts"), CYPRESS_DESTINATION.append(PRIMARY_APP).append("Home.spec.ts")).and().optionalReplacements().in(JHipsterModule.path("tsconfig.json")).add(EXISTING_EXCLUSION_REPLACER, "$1, \"src/test/javascript/integration/**/*.ts\"]")).add(EMPTY_EXCLUSION_REPLACER, "$1\"src/test/javascript/integration/**/*.ts\"]")).add(NEW_EXCLUSION_REPLACER, this.newExclusionNode(properties))).and()).and().build();
    }

    private String newExclusionNode(JHipsterModuleProperties properties) {
        return "," + "\n" + properties.indentation().spaces() + "\"exclude\": [\"src/test/javascript/integration/**/*.ts\"]" + "\n" + "}";
    }
}

