/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.vue.core.domain;

import tech.jhipster.lite.generator.client.common.domain.ClientsModulesFactory;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.packagejson.VersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class VueModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/vue");
    private static final JHipsterSource DOCUMENTATION_SOURCE = SOURCE.append("documentation");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test/spec");
    private static final JHipsterSource IMAGE_SOURCE = SOURCE.append("webapp/content/images");
    private static final JHipsterSource COMMON_PRIMARY_SOURCE = SOURCE.append("webapp/app/common/primary");
    private static final JHipsterSource COMMON_PRIMARY_TEST_SOURCE = SOURCE.append("test/spec/common/primary");
    private static final JHipsterSource SOURCE_COMMON = JHipsterModule.from("client/common");
    private static final JHipsterDestination MAIN_DESTINATION = JHipsterModule.to("src/main/webapp/app");
    private static final JHipsterDestination TEST_DESTINATION = JHipsterModule.to("src/test/javascript/spec");
    private static final JHipsterDestination MAIN_PRIMARY_DESTINATION = MAIN_DESTINATION.append("common/primary");
    private static final JHipsterDestination COMMON_PRIMARY_TEST_DESTINATION = JHipsterModule.to("src/test/javascript/spec/common/primary");
    private static final String IMPORT_NEEDLE = "// jhipster-needle-main-ts-import";
    private static final String PROVIDER_NEEDLE = "// jhipster-needle-main-ts-provider";
    private static final String PINIA_IMPORTS = "import { createPinia } from 'pinia';\nimport piniaPersist from 'pinia-plugin-persist';\n";
    private static final String PINIA_PROVIDER = "const pinia = createPinia();\npinia.use(piniaPersist);\napp.use(pinia);\n";

    public JHipsterModule buildVueModule(JHipsterModuleProperties properties) {
        return ClientsModulesFactory.clientModuleBuilder(properties).documentation(JHipsterModule.documentationTitle("Vue"), DOCUMENTATION_SOURCE.file("vue.md")).packageJson().addType("module").addDependency(JHipsterModule.packageName("vue"), VersionSource.VUE).addDependency(JHipsterModule.packageName("axios"), VersionSource.VUE).addDependency(JHipsterModule.packageName("vue-router"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@typescript-eslint/parser"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("@vitejs/plugin-vue"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/eslint-config-typescript"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/eslint-config-prettier"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/test-utils"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vitest/coverage-istanbul"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("eslint"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("eslint-plugin-vue"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("jsdom"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("typescript"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vite"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vitest"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vitest-sonar-reporter"), VersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vue-tsc"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@types/sinon"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("sinon"), VersionSource.VUE).addScript(JHipsterModule.scriptKey("build"), JHipsterModule.scriptCommand("vue-tsc -p tsconfig.build.json --noEmit && vite build --emptyOutDir")).addScript(JHipsterModule.scriptKey("dev"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("lint"), JHipsterModule.scriptCommand("eslint --ext .js,.ts,.vue src/")).addScript(JHipsterModule.scriptKey("preview"), JHipsterModule.scriptCommand("vite preview")).addScript(JHipsterModule.scriptKey("start"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("test"), JHipsterModule.scriptCommand("npm run test:watch")).addScript(JHipsterModule.scriptKey("test:coverage"), JHipsterModule.scriptCommand("vitest run --coverage")).addScript(JHipsterModule.scriptKey("test:watch"), JHipsterModule.scriptCommand("vitest --")).and().files().add(SOURCE.file(".eslintrc.cjs"), JHipsterModule.to(".eslintrc.cjs")).add(SOURCE.file("tsconfig.json"), JHipsterModule.to("tsconfig.json")).add(SOURCE.file("tsconfig.build.json"), JHipsterModule.to("tsconfig.build.json")).add(SOURCE.template("webapp/app/http/AxiosHttp.ts.mustache"), MAIN_DESTINATION.append("http/AxiosHttp.ts")).batch(SOURCE, JHipsterModule.to(".")).addTemplate("vite.config.ts").addTemplate("vitest.config.ts").and().batch(SOURCE_COMMON, JHipsterModule.to(".")).addFile(".eslintignore").addFile(".npmrc").and().batch(SOURCE.file("test/spec/http"), JHipsterModule.to("src/test/javascript/spec/http")).addTemplate("AxiosHttp.spec.ts").addTemplate("AxiosHttpStub.ts").addTemplate("AxiosStub.ts").and().add(SOURCE.template("webapp/index.html"), JHipsterModule.to("src/main/webapp/index.html")).batch(SOURCE.append("webapp/app"), MAIN_DESTINATION).addTemplate("env.d.ts").addTemplate("main.ts").and().batch(COMMON_PRIMARY_SOURCE.append("app"), MAIN_PRIMARY_DESTINATION.append("app")).addTemplate("App.component.ts").addTemplate("App.html").addTemplate("AppVue.vue").addTemplate("index.ts").and().batch(IMAGE_SOURCE, JHipsterModule.to("src/main/webapp/content/images")).addFile("JHipster-Lite-neon-green.png").addFile("VueLogo.png").and().add(COMMON_PRIMARY_TEST_SOURCE.template("app/App.spec.ts"), COMMON_PRIMARY_TEST_DESTINATION.append("app/App.spec.ts")).batch(COMMON_PRIMARY_SOURCE.append("homepage"), MAIN_PRIMARY_DESTINATION.append("homepage")).addTemplate("Homepage.component.ts").addTemplate("Homepage.html").addTemplate("HomepageVue.vue").addTemplate("index.ts").and().add(COMMON_PRIMARY_TEST_SOURCE.template("homepage/Homepage.spec.ts"), COMMON_PRIMARY_TEST_DESTINATION.append("homepage/Homepage.spec.ts")).add(SOURCE.template("webapp/app/router/router.ts"), MAIN_DESTINATION.append("router/router.ts")).add(SOURCE.template("test/spec/router/Router.spec.ts"), JHipsterModule.to("src/test/javascript/spec/router/Router.spec.ts")).batch(SOURCE.append("webapp/app/common/domain"), MAIN_DESTINATION.append("common/domain")).addTemplate("Logger.ts").addTemplate("Message.ts").and().add(SOURCE.template("webapp/app/common/secondary/ConsoleLogger.ts"), MAIN_DESTINATION.append("common/secondary/ConsoleLogger.ts")).add(SOURCE.template("test/spec/common/domain/Logger.fixture.ts"), JHipsterModule.to("src/test/javascript/spec/common/domain/Logger.fixture.ts")).add(SOURCE.template("test/spec/common/secondary/ConsoleLogger.spec.ts"), JHipsterModule.to("src/test/javascript/spec/common/secondary/ConsoleLogger.spec.ts")).add(SOURCE.file("webapp/app/vue/VueProp.ts"), JHipsterModule.to("src/main/webapp/app/vue/VueProp.ts")).batch(TEST_SOURCE.append("vue/vue-prop"), TEST_DESTINATION.append("vue/vue-prop")).addFile("ArrayComponentVue.vue").addFile("ObjectComponentVue.vue").addFile("VueProp.spec.ts").and().and().build();
    }

    public JHipsterModule buildPiniaModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("pinia"), VersionSource.VUE).addDependency(JHipsterModule.packageName("pinia-plugin-persist"), VersionSource.VUE).addDevDependency(JHipsterModule.packageName("@pinia/testing"), VersionSource.VUE).and().mandatoryReplacements().in(JHipsterModule.path("src/main/webapp/app/main.ts")).add(JHipsterModule.lineBeforeText(IMPORT_NEEDLE), PINIA_IMPORTS)).add(JHipsterModule.lineBeforeText(PROVIDER_NEEDLE), PINIA_PROVIDER)).and()).and().build();
    }
}

