/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.sonarqube.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SonarQubeModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/sonar");
    private static final JHipsterDestination SONAR_PROPERTIES_DESTINATION = JHipsterModule.to("sonar-project.properties");
    private static final String SONARQUBE = "sonarqube";
    private final DockerImages dockerImages;

    public SonarQubeModulesFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildBackendModule(JHipsterModuleProperties properties) {
        return this.commonModuleFiles(properties).files().add(SOURCE.template("sonar-project.properties"), SONAR_PROPERTIES_DESTINATION).and().build();
    }

    public JHipsterModule buildBackendFrontendModule(JHipsterModuleProperties properties) {
        return this.commonModuleFiles(properties).files().add(SOURCE.template("sonar-fullstack-project.properties"), SONAR_PROPERTIES_DESTINATION).and().build();
    }

    private JHipsterModule.JHipsterModuleBuilder commonModuleFiles(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("sonarqubeDockerImage", this.dockerImages.get(SONARQUBE).fullName()).and().documentation(JHipsterModule.documentationTitle("sonar"), SOURCE.template("sonar.md")).startupCommands().dockerCompose("src/main/docker/sonar.yml").maven("clean verify sonar:sonar").gradle("clean build sonar --info").and().mavenPlugins().pluginManagement(this.propertiesPlugin()).plugin(SonarQubeModulesFactory.propertiesPluginBuilder().build()).pluginManagement(this.sonarPlugin()).and().gradlePlugins().plugin(this.gradleSonarPlugin()).and().files().add(SOURCE.template("sonar.yml"), JHipsterModule.toSrcMainDocker().append("sonar.yml")).and();
    }

    private MavenPlugin propertiesPlugin() {
        return SonarQubeModulesFactory.propertiesPluginBuilder().versionSlug("properties-maven-plugin").addExecution(JHipsterModule.pluginExecution().goals("read-project-properties").id("default-cli").phase(MavenBuildPhase.INITIALIZE).configuration("<files>\n  <file>sonar-project.properties</file>\n</files>\n")).build();
    }

    private static MavenPlugin.MavenPluginOptionalBuilder propertiesPluginBuilder() {
        return MavenPlugin.builder().groupId("org.codehaus.mojo").artifactId("properties-maven-plugin");
    }

    private MavenPlugin sonarPlugin() {
        return MavenPlugin.builder().groupId("org.sonarsource.scanner.maven").artifactId("sonar-maven-plugin").versionSlug("sonar-maven-plugin").build();
    }

    private GradleMainBuildPlugin gradleSonarPlugin() {
        String configuration = "val sonarProperties = Properties()\nFile(\"sonar-project.properties\").inputStream().use { inputStream ->\n    sonarProperties.load(inputStream)\n}\n\nsonarqube {\n    properties {\n      sonarProperties\n        .map { it -> it.key as String to (it.value as String).split(\",\").map { it.trim() } }\n        .forEach { (key, values) -> property(key, values) }\n      property(\"sonar.coverage.jacoco.xmlReportPaths\", \"build/reports/jacoco/test/jacocoTestReport.xml\")\n      property(\"sonar.junit.reportPaths\", \"build/test-results/test,build/test-results/integrationTest\")\n    }\n}\n";
        return GradleCommunityPlugin.builder().id("org.sonarqube").pluginSlug(SONARQUBE).versionSlug(SONARQUBE).withBuildGradleImport("java.util.Properties").configuration(configuration).build();
    }
}

