/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.LocalEnvironment;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.TextNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

final class JHipsterModuleShortcuts {
    private static final JHipsterProjectFilePath README = JHipsterModule.path("README.md");
    private static final TextNeedleBeforeReplacer JHIPSTER_DOCUMENTATION_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-documentation -->");
    private static final TextNeedleBeforeReplacer JHIPSTER_LOCAL_ENVIRONMENT_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-localEnvironment -->");
    private static final TextNeedleAfterReplacer JHIPSTER_PREREQUISITES = JHipsterModule.lineAfterText("\n## Prerequisites");
    private static final JHipsterProjectFilePath SPRING_MAIN_LOG_FILE = JHipsterModule.path("src/main/resources/logback-spring.xml");
    private static final JHipsterProjectFilePath SPRING_TEST_LOG_FILE = JHipsterModule.path("src/test/resources/logback.xml");
    private static final TextNeedleBeforeReplacer JHIPSTER_LOGGER_NEEDLE = JHipsterModule.lineBeforeText("<!-- jhipster-needle-logback-add-log -->");
    private final JHipsterModule.JHipsterModuleBuilder builder;

    JHipsterModuleShortcuts(JHipsterModule.JHipsterModuleBuilder builder) {
        Assert.notNull("builder", builder);
        this.builder = builder;
    }

    void documentation(DocumentationTitle title, JHipsterSource source) {
        Assert.notNull("title", title);
        Assert.notNull("source", source);
        String target = "documentation/" + title.filename() + source.extension();
        this.builder.files().add(source, JHipsterModule.to(target));
        String markdownLink = "- [" + title.get() + "](" + target + ")";
        this.builder.optionalReplacements().in(README).add(JHIPSTER_DOCUMENTATION_NEEDLE, markdownLink);
    }

    void localEnvironment(LocalEnvironment localEnvironment) {
        Assert.notNull("localEnvironment", localEnvironment);
        this.builder.optionalReplacements().in(README).add(JHIPSTER_LOCAL_ENVIRONMENT_NEEDLE, localEnvironment.get());
    }

    void prerequisites(String prerequisites) {
        Assert.notBlank("prerequisites", prerequisites);
        this.builder.optionalReplacements().in(README).add(JHIPSTER_PREREQUISITES, prerequisites);
    }

    void springTestLogger(String name, LogLevel level) {
        Assert.notBlank("name", name);
        Assert.notNull("level", (Object)level);
        this.builder.optionalReplacements().in(SPRING_TEST_LOG_FILE).add(JHIPSTER_LOGGER_NEEDLE, this.logger(name, level));
    }

    void springMainLogger(String name, LogLevel level) {
        Assert.notBlank("name", name);
        Assert.notNull("level", (Object)level);
        this.builder.optionalReplacements().in(SPRING_MAIN_LOG_FILE).add(JHIPSTER_LOGGER_NEEDLE, this.logger(name, level));
    }

    private String logger(String name, LogLevel level) {
        return this.builder.indentation().spaces() + "<logger name=\"" + name + "\" level=\"" + level.value() + "\" />";
    }

    public void integrationTestExtension(String extensionClass) {
        Assert.notBlank("extensionClass", extensionClass);
        ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)this.builder.mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(this.builder.packagePath()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(" + extensionClass + ".class)");
    }
}

