/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.gradleplugin.GradlePluginSlug;
import tech.jhipster.lite.module.domain.javabuild.DependencySlug;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyVersion;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.gradle.InvalidTomlVersionCatalogException;

public class VersionsCatalog {
    private static final String VERSIONS_TOML_KEY = "versions";
    private static final String LIBRARIES_TOML_KEY = "libraries";
    private static final String PLUGINS_TOML_KEY = "plugins";
    private static final String VERSION_REF = "version.ref";
    private final FileConfig tomlConfigFile;

    public VersionsCatalog(JHipsterProjectFolder projectFolder) {
        this(VersionsCatalog.tomlVersionCatalogPath(projectFolder));
    }

    public VersionsCatalog(Path tomlVersionCatalogFile) {
        this.tomlConfigFile = FileConfig.builder((Path)tomlVersionCatalogFile).sync().build();
        if (!Files.exists(tomlVersionCatalogFile.getParent(), new LinkOption[0])) {
            tomlVersionCatalogFile.toFile().getParentFile().mkdirs();
        }
        try {
            this.tomlConfigFile.load();
        }
        catch (ParsingException exception) {
            throw new InvalidTomlVersionCatalogException(exception);
        }
    }

    private static Path tomlVersionCatalogPath(JHipsterProjectFolder projectFolder) {
        return projectFolder.filePath("gradle").resolve("libs.versions.toml");
    }

    private void save() {
        this.tomlConfigFile.save();
    }

    public static String libraryAlias(JavaDependency dependency) {
        return dependency.slug().map(DependencySlug::slug).or(() -> Optional.of(dependency.id().artifactId().get())).map(StringUtils::uncapitalize).orElseThrow();
    }

    public void setVersion(JavaDependencyVersion javaDependencyVersion) {
        this.tomlConfigFile.set(List.of(VERSIONS_TOML_KEY, javaDependencyVersion.slug().slug()), (Object)javaDependencyVersion.version().get());
        this.save();
    }

    public void addLibrary(JavaDependency dependency) {
        Config libraryConfig = Config.inMemory();
        libraryConfig.set("group", (Object)dependency.id().groupId().get());
        libraryConfig.set("name", (Object)dependency.id().artifactId().get());
        dependency.version().ifPresent(versionSlug -> libraryConfig.set(VERSION_REF, (Object)versionSlug.slug()));
        String libraryEntryKey = VersionsCatalog.libraryAlias(dependency);
        this.tomlConfigFile.set(List.of(LIBRARIES_TOML_KEY, libraryEntryKey), (Object)libraryConfig);
        this.save();
    }

    public void removeLibrary(DependencyId dependency) {
        this.libraryEntriesMatchingDependency(dependency).forEach(libraryConfig -> {
            this.tomlConfigFile.remove(List.of(LIBRARIES_TOML_KEY, libraryConfig.getKey()));
            this.removeUnusedVersion((Config.Entry)libraryConfig);
        });
        this.save();
    }

    private List<? extends Config.Entry> libraryEntriesMatchingDependency(DependencyId dependency) {
        return this.tomlConfigFile.entrySet().stream().filter(entry -> entry.getKey().equals(LIBRARIES_TOML_KEY)).map(UnmodifiableConfig.Entry::getValue).filter(Config.class::isInstance).map(Config.class::cast).map(Config::entrySet).flatMap(Collection::stream).filter(VersionsCatalog.groupShouldMatch(dependency)).filter(VersionsCatalog.nameShouldMatch(dependency)).toList();
    }

    private void removeUnusedVersion(Config.Entry libraryConfig) {
        VersionSlug.of(VersionsCatalog.versionReference(libraryConfig)).ifPresent(versionSlug -> {
            if (VersionsCatalog.versionUnused(this.tomlConfigFile, versionSlug)) {
                this.removeVersion((VersionSlug)versionSlug);
            }
        });
    }

    private static String versionReference(Config.Entry libraryConfig) {
        return (String)((Config)libraryConfig.getValue()).get(VERSION_REF);
    }

    private static boolean versionUnused(FileConfig tomlConfigFile, VersionSlug versionSlug) {
        return tomlConfigFile.entrySet().stream().filter(entry -> entry.getKey().equals(LIBRARIES_TOML_KEY)).map(UnmodifiableConfig.Entry::getValue).filter(Config.class::isInstance).map(Config.class::cast).map(Config::entrySet).flatMap(Collection::stream).noneMatch(VersionsCatalog.versionShouldMatch(versionSlug));
    }

    private static Predicate<Config.Entry> versionShouldMatch(VersionSlug versionSlug) {
        return libraryConfig -> {
            String versionProperty = VersionsCatalog.versionReference(libraryConfig);
            return versionProperty.equals(versionSlug.slug());
        };
    }

    private void removeVersion(VersionSlug versionSlug) {
        this.tomlConfigFile.remove(List.of(VERSIONS_TOML_KEY, versionSlug.slug()));
        this.save();
    }

    private static Predicate<Config.Entry> groupShouldMatch(DependencyId dependency) {
        return libraryConfig -> {
            Object groupProperty = ((Config)libraryConfig.getValue()).get("group");
            return dependency.groupId().get().equals(groupProperty);
        };
    }

    private static Predicate<Config.Entry> nameShouldMatch(DependencyId dependency) {
        return libraryConfig -> {
            Object groupProperty = ((Config)libraryConfig.getValue()).get("name");
            return dependency.artifactId().get().equals(groupProperty);
        };
    }

    public Collection<DependencySlug> retrieveDependencySlugsFrom(DependencyId dependency) {
        return this.libraryEntriesMatchingDependency(dependency).stream().map(UnmodifiableConfig.Entry::getKey).map(DependencySlug::new).toList();
    }

    public Collection<JavaDependencyVersion> retrieveVersions() {
        return this.tomlConfigFile.entrySet().stream().filter(entry -> entry.getKey().equals(VERSIONS_TOML_KEY)).map(UnmodifiableConfig.Entry::getValue).filter(Config.class::isInstance).map(Config.class::cast).map(Config::entrySet).flatMap(Collection::stream).map(entry -> new JavaDependencyVersion(entry.getKey(), (String)entry.getValue())).toList();
    }

    public static String pluginAlias(GradleCommunityPlugin communityPlugin) {
        return communityPlugin.pluginSlug().map(GradlePluginSlug::get).orElse(communityPlugin.id().get());
    }

    public void addPlugin(GradleCommunityPlugin plugin) {
        Config pluginConfig = Config.inMemory();
        pluginConfig.set("id", (Object)plugin.id().get());
        plugin.versionSlug().ifPresent(versionSlug -> pluginConfig.set(VERSION_REF, (Object)versionSlug.slug()));
        String pluginEntryKey = VersionsCatalog.pluginAlias(plugin);
        this.tomlConfigFile.set(List.of(PLUGINS_TOML_KEY, pluginEntryKey), (Object)pluginConfig);
        this.save();
    }
}

