/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.npm;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.module.domain.ProjectFiles;
import tech.jhipster.lite.module.domain.npm.NpmPackage;
import tech.jhipster.lite.module.domain.npm.NpmPackagesVersions;
import tech.jhipster.lite.module.domain.npm.NpmVersionSource;
import tech.jhipster.lite.module.infrastructure.secondary.npm.NpmVersionSourceFolder;
import tech.jhipster.lite.module.infrastructure.secondary.npm.NpmVersionsReader;
import tech.jhipster.lite.shared.enumeration.domain.Enums;

@Repository
@Order
class FileSystemNpmVersionReader
implements NpmVersionsReader {
    private static final Pattern DEV_DEPENDENCIES_PATTERN = Pattern.compile("\"devDependencies\"\\s*:\\s*\\{([^}]*)\\}", 32);
    private static final Pattern DEPENDENCIES_PATTERN = Pattern.compile("\"dependencies\"\\s*:\\s*\\{([^}]*)\\}", 32);
    private static final Pattern PACKAGES_PATTERN = Pattern.compile("\"([^\"]+)\"\\s*:\\s*\"([^\"]+)\"", 32);
    private final ProjectFiles projectFiles;

    public FileSystemNpmVersionReader(ProjectFiles projectFiles) {
        this.projectFiles = projectFiles;
    }

    @Override
    public NpmPackagesVersions get() {
        NpmPackagesVersions.NpmPackagesVersionsBuilder builder = NpmPackagesVersions.builder();
        Stream.of(NpmVersionSource.values()).forEach(source -> builder.put((NpmVersionSource)((Object)source), this.sourcePackages((NpmVersionSource)((Object)source))));
        return builder.build();
    }

    private Collection<NpmPackage> sourcePackages(NpmVersionSource source) {
        String sourceFile = this.readVersionsFile(source);
        return Stream.concat(this.packagesIn(sourceFile, DEV_DEPENDENCIES_PATTERN), this.packagesIn(sourceFile, DEPENDENCIES_PATTERN)).toList();
    }

    private Stream<NpmPackage> packagesIn(String source, Pattern pattern) {
        Matcher dependenciesMatcher = pattern.matcher(source);
        if (dependenciesMatcher.find()) {
            return this.readPackages(dependenciesMatcher.group(1));
        }
        return Stream.of(new NpmPackage[0]);
    }

    private Stream<NpmPackage> readPackages(String content) {
        return PACKAGES_PATTERN.matcher(content).results().map(result -> new NpmPackage(result.group(1), result.group(2)));
    }

    private String readVersionsFile(NpmVersionSource source) {
        return this.projectFiles.readString("/generator/dependencies/" + this.sourceFolder(source) + "/package.json");
    }

    private String sourceFolder(NpmVersionSource source) {
        return Enums.map(source, NpmVersionSourceFolder.class).folder();
    }
}

