/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.error.domain;

import java.util.Map;
import java.util.regex.Pattern;
import tech.jhipster.lite.shared.error.domain.AssertionErrorType;
import tech.jhipster.lite.shared.error.domain.AssertionException;

public final class NotMatchingExpectedPatternException
extends AssertionException {
    private final String pattern;

    private NotMatchingExpectedPatternException(NotMatchingExpectedPatternExceptionBuilder builder) {
        super(builder.field, builder.message());
        this.pattern = builder.pattern;
    }

    public static NotMatchingExpectedPatternExceptionBuilder builder() {
        return new NotMatchingExpectedPatternExceptionBuilder();
    }

    @Override
    public AssertionErrorType type() {
        return AssertionErrorType.STRING_NOT_MATCHING_PATTERN;
    }

    @Override
    public Map<String, String> parameters() {
        return Map.of("pattern", this.pattern);
    }

    public static final class NotMatchingExpectedPatternExceptionBuilder {
        private String value;
        private String pattern;
        private String field;

        private NotMatchingExpectedPatternExceptionBuilder() {
        }

        NotMatchingExpectedPatternExceptionBuilder field(String field) {
            this.field = field;
            return this;
        }

        NotMatchingExpectedPatternExceptionBuilder value(String value) {
            this.value = value;
            return this;
        }

        NotMatchingExpectedPatternExceptionBuilder pattern(Pattern pattern) {
            this.pattern = pattern.pattern();
            return this;
        }

        private String message() {
            return "The value \"" + this.value + "\" in field \"" + this.field + "\" must match the pattern " + this.pattern;
        }

        public NotMatchingExpectedPatternException build() {
            return new NotMatchingExpectedPatternException(this);
        }
    }
}

