/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.shared.error.domain;

import java.util.Map;
import tech.jhipster.lite.shared.error.domain.AssertionErrorType;
import tech.jhipster.lite.shared.error.domain.AssertionException;

public class TooManyElementsException
extends AssertionException {
    private final String maxSize;
    private final String currentSize;

    public TooManyElementsException(TooManyElementsExceptionBuilder builder) {
        super(builder.field, builder.message());
        this.maxSize = String.valueOf(builder.maxSize);
        this.currentSize = String.valueOf(builder.size);
    }

    public static TooManyElementsExceptionBuilder builder() {
        return new TooManyElementsExceptionBuilder();
    }

    @Override
    public AssertionErrorType type() {
        return AssertionErrorType.TOO_MANY_ELEMENTS;
    }

    @Override
    public Map<String, String> parameters() {
        return Map.of("maxSize", this.maxSize, "currentSize", this.currentSize);
    }

    public static class TooManyElementsExceptionBuilder {
        private String field;
        private int maxSize;
        private int size;

        public TooManyElementsExceptionBuilder field(String field) {
            this.field = field;
            return this;
        }

        public TooManyElementsExceptionBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public TooManyElementsExceptionBuilder size(int size) {
            this.size = size;
            return this;
        }

        private String message() {
            return "Size of collection \"" + this.field + "\" must be at most " + this.maxSize + " but was " + this.size;
        }

        public TooManyElementsException build() {
            return new TooManyElementsException(this);
        }
    }
}

