/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.ci.github.actions.domain;

import java.util.Locale;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.JavaBuildTool;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class GitHubActionsModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("ci/github/actions/.github");
    private final NpmVersions npmVersions;

    public GitHubActionsModuleFactory(NpmVersions npmVersions) {
        this.npmVersions = npmVersions;
    }

    public JHipsterModule buildGitHubActionsMavenModule(JHipsterModuleProperties properties) {
        return this.buildGitHubActionsModule(properties, JavaBuildTool.MAVEN);
    }

    public JHipsterModule buildGitHubActionsGradleModule(JHipsterModuleProperties properties) {
        return this.buildGitHubActionsModule(properties, JavaBuildTool.GRADLE);
    }

    private JHipsterModule buildGitHubActionsModule(JHipsterModuleProperties properties, JavaBuildTool javaBuildTool) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("nodeVersion", this.npmVersions.nodeVersion().get()).put(javaBuildTool.name().toLowerCase(Locale.ROOT), true).and().files().add(SOURCE.template("workflows/github-actions.yml"), JHipsterModule.to(".github/workflows/github-actions.yml")).and().build();
    }
}

