/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.vue.security.oauth2_keycloak.domain;

import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class VueOAuth2KeycloakModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/vue");
    private static final JHipsterSource APP_SOURCE = JHipsterModule.from("client/vue/security/oauth2_keycloak/webapp/app");
    private static final JHipsterSource DOCUMENTATION_SOURCE = SOURCE.append("documentation");
    private static final JHipsterDestination MAIN_DESTINATION = JHipsterModule.to("src/main/webapp/app");
    private static final JHipsterDestination TEST_DESTINATION = JHipsterModule.to("src/test/webapp");
    private static final String MAIN_TS_IMPORT_NEEDLE = "// jhipster-needle-main-ts-import";
    private static final String MAIN_TS_PROVIDER_NEEDLE = "// jhipster-needle-main-ts-provider";
    private static final String KEYCLOAK_IMPORT = "import { provideForAuth } from '@/auth/application/AuthProvider';\nimport { KeycloakHttp } from '@/auth/infrastructure/secondary/KeycloakHttp';\nimport Keycloak from 'keycloak-js';";
    private static final String KEYCLOAK_SETUP = "const keycloakHttp = new KeycloakHttp(\n%snew Keycloak({\n%surl: 'http://localhost:9080',\n%srealm: 'jhipster',\n%sclientId: 'web_app',\n%s}),\n);\n\nprovideForAuth(keycloakHttp);";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        Indentation indentation = properties.indentation();
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).documentation(JHipsterModule.documentationTitle("Vue OAuth2 Keycloak Authentication Components"), DOCUMENTATION_SOURCE.template("vue-oauth2-keycloak-authentication-components.md")).packageJson().addDependency(JHipsterModule.packageName("keycloak-js"), JHLiteNpmVersionSource.COMMON).and().files().batch(APP_SOURCE.append("auth"), MAIN_DESTINATION.append("auth")).addTemplate("application/AuthProvider.ts").addTemplate("domain/AuthRepository.ts").addTemplate("domain/AuthenticatedUser.ts").addTemplate("infrastructure/secondary/KeycloakAuthRepository.ts").addTemplate("infrastructure/secondary/KeycloakHttp.ts").and().add(APP_SOURCE.template("test/webapp/unit/auth/application/AuthProvider.spec.ts"), TEST_DESTINATION.append("unit/auth/application/AuthProvider.spec.ts")).batch(APP_SOURCE.append("test/webapp/unit/auth/infrastructure/secondary"), TEST_DESTINATION.append("unit/auth/infrastructure/secondary")).addTemplate("KeycloakAuthRepository.spec.ts").addTemplate("KeycloakHttp.spec.ts").addTemplate("KeycloakHttpStub.ts").addTemplate("KeycloakStub.ts").and().and().mandatoryReplacements().in(JHipsterModule.path("src/main/webapp/app/main.ts")).add(JHipsterModule.lineBeforeText(MAIN_TS_IMPORT_NEEDLE), KEYCLOAK_IMPORT)).add(JHipsterModule.lineBeforeText(MAIN_TS_PROVIDER_NEEDLE), KEYCLOAK_SETUP.formatted(indentation.spaces(), indentation.times(2), indentation.times(2), indentation.times(2), indentation.spaces()))).and()).and().build();
    }
}

