/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.init.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class InitModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("init");
    private static final JHipsterDestination DESTINATION = JHipsterModule.to(".");
    private static final JHipsterSource SOURCE_COMMON = JHipsterModule.from("client/common");
    private final NpmVersions npmVersions;

    public InitModuleFactory(NpmVersions npmVersions) {
        Assert.notNull("npmVersions", npmVersions);
        this.npmVersions = npmVersions;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).put("nodeMajorVersion", this.npmVersions.nodeVersion().majorVersion()).put("endOfLine", this.endOfLine(properties)).and().files().batch(SOURCE, DESTINATION).addTemplate("README.md").addTemplate("package.json").addTemplate(".editorconfig").addFile(".lintstagedrc.cjs").and().batch(SOURCE_COMMON, DESTINATION).addFile(".npmrc").and().addExecutable(SOURCE.append(".husky").file("pre-commit"), DESTINATION.append(".husky/pre-commit")).add(SOURCE.file("gitignore"), JHipsterModule.to(".gitignore")).add(SOURCE.file("gitattributes"), JHipsterModule.to(".gitattributes")).and().packageJson().addDevDependency(JHipsterModule.packageName("husky"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("lint-staged"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("prepare"), JHipsterModule.scriptCommand("husky")).and().build();
    }

    private String endOfLine(JHipsterModuleProperties properties) {
        return properties.getOrDefaultString("endOfLine", "lf");
    }
}

