/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.datasource.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.database.datasource.application.DatasourceApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class DatasourceModuleConfiguration {
    private static final String API_DOC_GROUP = "Spring Boot - Database";

    DatasourceModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource postgresqlDatasourceModule(DatasourceApplicationService datasource) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.DATASOURCE_POSTGRESQL).propertiesDefinition(DatasourceModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add Postgresql datasource to Spring project").organization(DatasourceModuleConfiguration.organization()).tags(DatasourceModuleConfiguration.tags()).factory(datasource::buildPostgresql);
    }

    @Bean
    JHipsterModuleResource mariaDBDatasourceModule(DatasourceApplicationService datasource) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.DATASOURCE_MARIADB).propertiesDefinition(DatasourceModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add MariaDB datasource to Spring project").organization(DatasourceModuleConfiguration.organization()).tags(DatasourceModuleConfiguration.tags()).factory(datasource::buildMariaDB);
    }

    @Bean
    JHipsterModuleResource mmySQLDatasourceModule(DatasourceApplicationService datasource) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.DATASOURCE_MYSQL).propertiesDefinition(DatasourceModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add MySQL datasource to Spring project").organization(DatasourceModuleConfiguration.organization()).tags(DatasourceModuleConfiguration.tags()).factory(datasource::buildMySQL);
    }

    @Bean
    JHipsterModuleResource msSQLDatasourceModule(DatasourceApplicationService datasource) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.DATASOURCE_MSSQL).propertiesDefinition(DatasourceModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add MsSQL datasource to Spring project").organization(DatasourceModuleConfiguration.organization()).tags(DatasourceModuleConfiguration.tags()).factory(datasource::buildMsSQL);
    }

    private static JHipsterModulePropertiesDefinition properties() {
        return JHipsterModulePropertiesDefinition.builder().addIndentation().addProjectBaseName().addSpringConfigurationFormat().build();
    }

    private static JHipsterModuleOrganization organization() {
        return JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.DATASOURCE).addDependency(JHLiteModuleSlug.SPRING_BOOT).build();
    }

    private static String[] tags() {
        return new String[]{"server", "spring", "spring-boot", "datasource", "database"};
    }
}

