/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jooq.domain;

import java.util.Optional;
import tech.jhipster.lite.shared.error.domain.Assert;

final class JooqModuleCodegenConfiguration {
    private final String databaseUrl;
    private final String user;
    private final String inputSchema;
    private final String jooqMetaDatabase;
    private final String password;

    private JooqModuleCodegenConfiguration(JooqModuleCodegenConfigurationBuilder builder) {
        Assert.notNull("databaseUrl", builder.databaseUrl);
        Assert.notNull("user", builder.user);
        Assert.notNull("inputSchema", builder.inputSchema);
        Assert.notNull("jooqMetaDatabase", builder.jooqMetaDatabase);
        this.databaseUrl = builder.databaseUrl;
        this.user = builder.user;
        this.inputSchema = builder.inputSchema;
        this.jooqMetaDatabase = builder.jooqMetaDatabase;
        this.password = Optional.ofNullable(builder.password).orElse("");
    }

    public static JooqModuleCodegenConfigurationDatabaseUrlBuilder builder() {
        return new JooqModuleCodegenConfigurationBuilder();
    }

    public String getConfiguration() {
        return String.format("<jdbc>\n  <url>%s</url>\n  <user>%s</user>\n  <password>%s</password>\n</jdbc>\n<generator>\n  <database>\n    <name>%s</name>\n    <includes>.*</includes>\n    <inputSchema>%s</inputSchema>\n  </database>\n  <target>\n    <packageName>org.jooq.codegen</packageName>\n    <directory>target/generated-sources/jooq</directory>\n  </target>\n</generator>\n", this.databaseUrl, this.user, this.password, this.jooqMetaDatabase, this.inputSchema);
    }

    private static final class JooqModuleCodegenConfigurationBuilder
    implements JooqModuleCodegenConfigurationDatabaseUrlBuilder,
    JooqModuleCodegenConfigurationUserBuilder,
    JooqModuleCodegenConfigurationInputSchemaBuilder,
    JooqModuleCodegenConfigurationJooqMetaDatabaseBuilder,
    JooqModuleCodegenConfigurationOptionalBuilder {
        private String databaseUrl;
        private String user;
        private String inputSchema;
        private String jooqMetaDatabase;
        private String password;

        private JooqModuleCodegenConfigurationBuilder() {
        }

        @Override
        public JooqModuleCodegenConfigurationUserBuilder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationInputSchemaBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationJooqMetaDatabaseBuilder inputSchema(String inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationOptionalBuilder jooqMetaDatabase(String jooqMetaDatabase) {
            this.jooqMetaDatabase = jooqMetaDatabase;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationOptionalBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public JooqModuleCodegenConfiguration build() {
            return new JooqModuleCodegenConfiguration(this);
        }
    }

    public static sealed interface JooqModuleCodegenConfigurationOptionalBuilder
    permits JooqModuleCodegenConfigurationBuilder {
        public JooqModuleCodegenConfigurationOptionalBuilder password(String var1);

        public JooqModuleCodegenConfiguration build();
    }

    public static sealed interface JooqModuleCodegenConfigurationJooqMetaDatabaseBuilder
    permits JooqModuleCodegenConfigurationBuilder {
        public JooqModuleCodegenConfigurationOptionalBuilder jooqMetaDatabase(String var1);
    }

    public static sealed interface JooqModuleCodegenConfigurationInputSchemaBuilder
    permits JooqModuleCodegenConfigurationBuilder {
        public JooqModuleCodegenConfigurationJooqMetaDatabaseBuilder inputSchema(String var1);
    }

    public static sealed interface JooqModuleCodegenConfigurationUserBuilder
    permits JooqModuleCodegenConfigurationBuilder {
        public JooqModuleCodegenConfigurationInputSchemaBuilder user(String var1);
    }

    public static sealed interface JooqModuleCodegenConfigurationDatabaseUrlBuilder
    permits JooqModuleCodegenConfigurationBuilder {
        public JooqModuleCodegenConfigurationUserBuilder databaseUrl(String var1);
    }
}

