/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jooq.domain;

import tech.jhipster.lite.generator.server.springboot.database.jooq.domain.JooqModuleCodegenConfiguration;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JooqModuleFactory {
    public JHipsterModule buildPostgresql(JHipsterModuleProperties properties) {
        return JooqModuleFactory.commonModuleBuilder(properties).mavenPlugins().plugin(JooqModuleFactory.jooqMavenCodegenPlugin(JooqModuleFactory.postgresqlPluginConfiguration(properties))).and().build();
    }

    private static String postgresqlPluginConfiguration(JHipsterModuleProperties properties) {
        return JooqModuleCodegenConfiguration.builder().databaseUrl("jdbc:postgresql://localhost:5432/" + properties.projectBaseName().name()).user(properties.projectBaseName().name()).inputSchema("public").jooqMetaDatabase("org.jooq.meta.postgres.PostgresDatabase").build().getConfiguration();
    }

    public JHipsterModule buildMariaDB(JHipsterModuleProperties properties) {
        return JooqModuleFactory.commonModuleBuilder(properties).mavenPlugins().plugin(JooqModuleFactory.jooqMavenCodegenPlugin(JooqModuleFactory.mariadbPluginConfiguration(properties))).and().build();
    }

    private static String mariadbPluginConfiguration(JHipsterModuleProperties properties) {
        return JooqModuleCodegenConfiguration.builder().databaseUrl("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name()).user("root").inputSchema(properties.projectBaseName().name()).jooqMetaDatabase("org.jooq.meta.mariadb.MariaDBDatabase").build().getConfiguration();
    }

    public JHipsterModule buildMySQL(JHipsterModuleProperties properties) {
        return JooqModuleFactory.commonModuleBuilder(properties).mavenPlugins().plugin(JooqModuleFactory.jooqMavenCodegenPlugin(JooqModuleFactory.mysqlPluginConfiguration(properties))).and().build();
    }

    private static String mysqlPluginConfiguration(JHipsterModuleProperties properties) {
        return JooqModuleCodegenConfiguration.builder().databaseUrl("jdbc:mysql://localhost:3306/" + properties.projectBaseName().name()).user("root").inputSchema(properties.projectBaseName().name()).jooqMetaDatabase("org.jooq.meta.mysql.MySQLDatabase").build().getConfiguration();
    }

    public JHipsterModule buildMsSQL(JHipsterModuleProperties properties) {
        return JooqModuleFactory.commonModuleBuilder(properties).mavenPlugins().plugin(JooqModuleFactory.jooqMavenCodegenPlugin(JooqModuleFactory.mssqlPluginConfiguration(properties))).and().build();
    }

    private static String mssqlPluginConfiguration(JHipsterModuleProperties properties) {
        return JooqModuleCodegenConfiguration.builder().databaseUrl("jdbc:sqlserver://localhost:1433;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true").user("SA").inputSchema("model").jooqMetaDatabase("org.jooq.meta.sqlserver.SQLServerDatabase").password("yourStrong(!)Password").build().getConfiguration();
    }

    public static JHipsterModule.JHipsterModuleBuilder commonModuleBuilder(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-jooq")).and();
    }

    private static MavenPlugin jooqMavenCodegenPlugin(String pluginConfiguration) {
        return JHipsterModule.mavenPlugin().groupId("org.jooq").artifactId("jooq-codegen-maven").versionSlug("jooq").addExecution(JHipsterModule.pluginExecution().goals("generate").id("jooq-codegen").phase(MavenBuildPhase.GENERATE_RESOURCES)).configuration(pluginConfiguration).build();
    }
}

