/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jpa.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.database.jpa.application.JpaApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class JpaModuleConfiguration {
    private static final String API_DOC_GROUP = "Spring Boot - Database";

    JpaModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource jpaPostgresqlModule(JpaApplicationService postgresql) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JPA_POSTGRESQL).propertiesDefinition(JpaModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add JPA with Postgresql to project").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.JPA_PERSISTENCE).addDependency(JHLiteModuleSlug.DATASOURCE_POSTGRESQL).build()).tags(JpaModuleConfiguration.tags()).factory(postgresql::buildPostgresql);
    }

    @Bean
    JHipsterModuleResource jpaMariaDBModule(JpaApplicationService mariaDB) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JPA_MARIADB).propertiesDefinition(JpaModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add JPA with MariaDB to project").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.JPA_PERSISTENCE).addDependency(JHLiteModuleSlug.DATASOURCE_MARIADB).build()).tags(JpaModuleConfiguration.tags()).factory(mariaDB::buildMariaDB);
    }

    @Bean
    JHipsterModuleResource jpaMmySQLModule(JpaApplicationService mySQL) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JPA_MYSQL).propertiesDefinition(JpaModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add JPA with MySQL to project").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.JPA_PERSISTENCE).addDependency(JHLiteModuleSlug.DATASOURCE_MYSQL).build()).tags(JpaModuleConfiguration.tags()).factory(mySQL::buildMySQL);
    }

    @Bean
    JHipsterModuleResource jpaMsSQLModule(JpaApplicationService msSQL) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JPA_MSSQL).propertiesDefinition(JpaModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add JPA with MsSQL to project").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.JPA_PERSISTENCE).addDependency(JHLiteModuleSlug.DATASOURCE_MSSQL).build()).tags(JpaModuleConfiguration.tags()).factory(msSQL::buildMsSQL);
    }

    private static JHipsterModulePropertiesDefinition properties() {
        return JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().addProjectBaseName().addSpringConfigurationFormat().build();
    }

    private static String[] tags() {
        return new String[]{"server", "spring", "spring-boot", "database"};
    }
}

