/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.dbmigration.flyway.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.dbmigration.flyway.application.FlywayApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class FlywayModuleConfiguration {
    private static final String API_DOC_GROUP = "Spring Boot - Database Migration";

    FlywayModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource flywayInitializationModule(FlywayApplicationService flyway) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.FLYWAY).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().addSpringConfigurationFormat().build()).apiDoc(API_DOC_GROUP, "Add Flyway").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.DATABASE_MIGRATION).addDependency(JHLiteFeatureSlug.DATASOURCE).build()).tags(this.flywayTags()).factory(flyway::buildInitializationModule);
    }

    @Bean
    JHipsterModuleResource flywayMysqlModule(FlywayApplicationService flyway) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.FLYWAY_MYSQL).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().build()).apiDoc(API_DOC_GROUP, "Add Flyway MySQL").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.FLYWAY).addDependency(JHLiteModuleSlug.DATASOURCE_MYSQL).build()).tags(this.flywayTags()).factory(flyway::buildMysqlDependencyModule);
    }

    @Bean
    JHipsterModuleResource flywayMariaDBModule(FlywayApplicationService flyway) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.FLYWAY_MARIADB).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().build()).apiDoc(API_DOC_GROUP, "Add Flyway MariaDB").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.FLYWAY).addDependency(JHLiteModuleSlug.DATASOURCE_MARIADB).build()).tags(this.flywayTags()).factory(flyway::buildMysqlDependencyModule);
    }

    @Bean
    JHipsterModuleResource flywayPostgresModule(FlywayApplicationService flyway) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.FLYWAY_POSTGRESQL).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().build()).apiDoc(API_DOC_GROUP, "Add Flyway PostgreSQL").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.FLYWAY).addDependency(JHLiteModuleSlug.DATASOURCE_POSTGRESQL).build()).tags(this.flywayTags()).factory(flyway::buildPostgresqlDependencyModule);
    }

    @Bean
    JHipsterModuleResource flywayMsSqlServerModule(FlywayApplicationService flyway) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.FLYWAY_MSSQL).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().build()).apiDoc(API_DOC_GROUP, "Add Flyway PostgreSQL").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.FLYWAY).addDependency(JHLiteModuleSlug.DATASOURCE_MSSQL).build()).tags(this.flywayTags()).factory(flyway::buildMsSqlServerDependencyModule);
    }

    private String[] flywayTags() {
        return new String[]{"server", "spring", "spring-boot", "database", "migration"};
    }
}

