/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.sample.jpapersistence.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleBeforeReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SampleJpaPersistenceModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/sample/jpapersistence");
    private static final String SECONDARY = "infrastructure/secondary";
    private static final String SECONDARY_DESTINATION = "sample/infrastructure/secondary";
    private static final TextNeedleBeforeReplacer IMPORT_NEEDLE = JHipsterModule.lineBeforeText("import org.springframework.stereotype.Service;");
    private static final TextNeedleBeforeReplacer CATALOG_METHOD_NEEDLE = new TextNeedleBeforeReplacer(ReplacementCondition.always(), "Beers catalog()");
    private static final RegexNeedleBeforeReplacer REMOVE_METHOD_NEEDLE = new RegexNeedleBeforeReplacer(ReplacementCondition.always(), Pattern.compile("^ +@PreAuthorize\\(\"can\\('remove', #beer\\)\"\\)\\n+ +public void remove\\(BeerId beer\\)", 8));
    private static final RegexNeedleBeforeReplacer CREATE_METHOD_NEEDLE = new RegexNeedleBeforeReplacer(ReplacementCondition.always(), Pattern.compile("^ +@PreAuthorize\\(\"can\\('create', #beerToCreate\\)\"\\)\\n+ +public Beer create\\(BeerToCreate beerToCreate\\)", 8));

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        String spaces = properties.indentation().spaces();
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).files().batch(SOURCE.append("main").append(SECONDARY), JHipsterModule.toSrcMainJava().append(packagePath).append(SECONDARY_DESTINATION)).addTemplate("BeerEntity.java").addTemplate("JpaBeersRepository.java").addTemplate("SpringDataBeersRepository.java").and().batch(SOURCE.append("test").append(SECONDARY), JHipsterModule.toSrcTestJava().append(packagePath).append(SECONDARY_DESTINATION)).addTemplate("BeerEntityTest.java").addTemplate("JpaBeersRepositoryIT.java").and().delete(JHipsterModule.path("src/main/java").append(packagePath).append(SECONDARY_DESTINATION).append("InMemoryBeersRepository.java")).delete(JHipsterModule.path("src/test/java").append(packagePath).append(SECONDARY_DESTINATION).append("InMemoryBeersResetter.java")).and().mandatoryReplacements().in(JHipsterModule.path("src/main/java").append(packagePath).append("sample/application/BeersApplicationService.java")).add(IMPORT_NEEDLE, "import org.springframework.transaction.annotation.Transactional;")).add(CATALOG_METHOD_NEEDLE, spaces + "@Transactional(readOnly = true)")).add(REMOVE_METHOD_NEEDLE, spaces + "@Transactional")).add(CREATE_METHOD_NEEDLE, spaces + "@Transactional")).and()).and().build();
    }
}

