/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.LocalEnvironment;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.PreCommitCommands;
import tech.jhipster.lite.module.domain.StagedFilesFilter;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.OptionalReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.domain.replacement.TextNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

final class JHipsterModuleShortcuts {
    private static final JHipsterProjectFilePath README = JHipsterModule.path("README.md");
    private static final TextNeedleBeforeReplacer JHIPSTER_DOCUMENTATION_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-documentation -->");
    private static final TextNeedleBeforeReplacer JHIPSTER_LOCAL_ENVIRONMENT_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-localEnvironment -->");
    private static final TextNeedleAfterReplacer JHIPSTER_PREREQUISITES = JHipsterModule.lineAfterText("\n## Prerequisites");
    private static final JHipsterProjectFilePath SPRING_MAIN_LOG_FILE = JHipsterModule.path("src/main/resources/logback-spring.xml");
    private static final JHipsterProjectFilePath SPRING_TEST_LOG_FILE = JHipsterModule.path("src/test/resources/logback.xml");
    private static final TextNeedleBeforeReplacer JHIPSTER_LOGGER_NEEDLE = JHipsterModule.lineBeforeText("<!-- jhipster-needle-logback-add-log -->");
    private static final Pattern DEFAULT_LINTSTAGED_CONFIGURATION_ENTRY = Pattern.compile("\\s*'\\*': \\[\\s*].*");

    private JHipsterModuleShortcuts() {
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> documentation(DocumentationTitle title, JHipsterSource source) {
        Assert.notNull("title", title);
        Assert.notNull("source", source);
        return builder -> {
            String target = "documentation/" + title.filename() + source.extension();
            builder.files().add(source, JHipsterModule.to(target));
            String markdownLink = "- [" + title.get() + "](" + target + ")";
            builder.optionalReplacements().in(README).add(JHIPSTER_DOCUMENTATION_NEEDLE, markdownLink);
        };
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> localEnvironment(LocalEnvironment localEnvironment) {
        Assert.notNull("localEnvironment", localEnvironment);
        return builder -> builder.optionalReplacements().in(README).add(JHIPSTER_LOCAL_ENVIRONMENT_NEEDLE, localEnvironment.get());
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> prerequisites(String prerequisites) {
        Assert.notBlank("prerequisites", prerequisites);
        return builder -> builder.optionalReplacements().in(README).add(JHIPSTER_PREREQUISITES, prerequisites);
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> springTestLogger(String name, LogLevel level) {
        Assert.notBlank("name", name);
        Assert.notNull("level", (Object)level);
        return builder -> builder.optionalReplacements().in(SPRING_TEST_LOG_FILE).add(JHipsterModuleShortcuts.logConfigurationEntry(name, level, builder.indentation()));
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> springMainLogger(String name, LogLevel level) {
        Assert.notBlank("name", name);
        Assert.notNull("level", (Object)level);
        return builder -> builder.optionalReplacements().in(SPRING_MAIN_LOG_FILE).add(JHipsterModuleShortcuts.logConfigurationEntry(name, level, builder.indentation()));
    }

    private static OptionalReplacer logConfigurationEntry(String name, LogLevel level, Indentation indentation) {
        return new OptionalReplacer(JHIPSTER_LOGGER_NEEDLE, JHipsterModuleShortcuts.logger(name, level, indentation));
    }

    private static String logger(String name, LogLevel level, Indentation indentation) {
        return indentation.spaces() + "<logger name=\"" + name + "\" level=\"" + level.value() + "\" />";
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> integrationTestExtension(String extensionClass) {
        Assert.notBlank("extensionClass", extensionClass);
        return builder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)builder.mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(builder.packagePath()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(" + extensionClass + ".class)");
    }

    static Consumer<JHipsterModule.JHipsterModuleBuilder> preCommitActions(StagedFilesFilter stagedFilesFilter, PreCommitCommands preCommitCommands) {
        Assert.notNull("stagedFilesFilter", stagedFilesFilter);
        Assert.notNull("preCommitCommands", preCommitCommands);
        return builder -> {
            String newLintStagedConfigurationEntry = "%s'%s': %s,".formatted(builder.properties().indentation().times(1), stagedFilesFilter, preCommitCommands);
            ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)builder.optionalReplacements().in(JHipsterModule.path(".lintstagedrc.cjs")).add(JHipsterModule.regex(ReplacementCondition.always(), DEFAULT_LINTSTAGED_CONFIGURATION_ENTRY), "")).add(JHipsterModule.lineAfterRegex("module.exports = \\{"), newLintStagedConfigurationEntry);
        };
    }
}

