/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javadependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import tech.jhipster.lite.module.domain.javadependency.DependencyId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JavaDependencies {
    public static final JavaDependencies EMPTY = new JavaDependencies(null);
    private final Map<DependencyId, JavaDependency> dependencies;

    public JavaDependencies(Collection<JavaDependency> dependencies) {
        this.dependencies = this.buildDependencies(dependencies);
    }

    private Map<DependencyId, JavaDependency> buildDependencies(Collection<JavaDependency> dependencies) {
        if (dependencies == null) {
            return Map.of();
        }
        return dependencies.stream().collect(Collectors.toUnmodifiableMap(JavaDependency::id, Function.identity()));
    }

    public Optional<JavaDependency> get(DependencyId id) {
        Assert.notNull("id", id);
        return Optional.ofNullable(this.dependencies.get(id));
    }

    public JavaDependencies merge(JavaDependencies other) {
        Assert.notNull("other", other);
        ArrayList<JavaDependency> mergedDependencies = new ArrayList<JavaDependency>(other.dependencies.values());
        mergedDependencies.addAll(this.dependencies.values());
        return new JavaDependencies(mergedDependencies);
    }
}

