/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.react.core.domain;

import java.util.function.Consumer;
import tech.jhipster.lite.generator.typescript.common.domain.EslintShortcuts;
import tech.jhipster.lite.generator.typescript.common.domain.TsConfigShortcuts;
import tech.jhipster.lite.generator.typescript.common.domain.VitestShortcuts;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmLazyInstaller;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.shared.error.domain.Assert;

public class ReactModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/react/core");
    private static final JHipsterSource WEBAPP_SOURCE = SOURCE.append("src/main/webapp");
    private static final JHipsterDestination WEBAPP_DESTINATION = JHipsterModule.to("src/main/webapp");
    private static final JHipsterSource APP_SOURCE = WEBAPP_SOURCE.append("app");
    private static final JHipsterDestination APP_DESTINATION = WEBAPP_DESTINATION.append("app");
    private static final JHipsterSource PIQURE_SOURCE = JHipsterModule.from("client/common/piqure");
    private static final String PRIMARY_APP = "home/infrastructure/primary";
    private static final String ASSETS = "assets";
    private static final JHipsterSource PRIMARY_APP_SOURCE = APP_SOURCE.append("home/infrastructure/primary");
    private static final JHipsterDestination PRIMARY_APP_DESTINATION = APP_DESTINATION.append("home/infrastructure/primary");
    private static final String TEST_PRIMARY = "src/test/webapp/unit/home/infrastructure/primary";
    private static final String DEFAULT_TSCONFIG_PATH = "\"@/*\": [\"src/main/webapp/app/*\"]";
    private final NpmLazyInstaller npmLazyInstaller;

    public ReactModuleFactory(NpmLazyInstaller npmLazyInstaller) {
        this.npmLazyInstaller = npmLazyInstaller;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).preCommitActions(JHipsterModule.stagedFilesFilter("{src/**/,}*.{ts,tsx}"), JHipsterModule.preCommitCommands("eslint --fix", "prettier --write")).packageJson().removeDevDependency(JHipsterModule.packageName("@tsconfig/recommended")).addDevDependency(JHipsterModule.packageName("@testing-library/dom"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("@testing-library/react"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("@types/node"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("@types/react"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("@types/react-dom"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("@tsconfig/vite-react"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("@vitejs/plugin-react"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("eslint-plugin-react"), JHLiteNpmVersionSource.REACT).addDevDependency(JHipsterModule.packageName("jsdom"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vite"), JHLiteNpmVersionSource.COMMON).addDependency(JHipsterModule.packageName("react"), JHLiteNpmVersionSource.REACT).addDependency(JHipsterModule.packageName("react-dom"), JHLiteNpmVersionSource.REACT).addDependency(JHipsterModule.packageName("piqure"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("dev"), JHipsterModule.scriptCommand("npm-run-all --parallel dev:*")).addScript(JHipsterModule.scriptKey("dev:vite"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("build"), JHipsterModule.scriptCommand("npm-run-all build:*")).addScript(JHipsterModule.scriptKey("build:tsc"), JHipsterModule.scriptCommand("tsc -b")).addScript(JHipsterModule.scriptKey("build:vite"), JHipsterModule.scriptCommand("vite build --emptyOutDir")).addScript(JHipsterModule.scriptKey("preview"), JHipsterModule.scriptCommand("vite preview")).addScript(JHipsterModule.scriptKey("start"), JHipsterModule.scriptCommand("vite")).and().postActions().add(context -> this.npmLazyInstaller.runInstallIn(context.projectFolder())).and().files().batch(SOURCE, JHipsterModule.to(".")).addTemplate("vite.config.ts").and().batch(APP_SOURCE, APP_DESTINATION).addTemplate("index.css").addTemplate("index.tsx").addTemplate("vite-env.d.ts").and().batch(PIQURE_SOURCE, APP_DESTINATION).addTemplate("injections.ts").and().add(WEBAPP_SOURCE.template("index.html"), WEBAPP_DESTINATION.append("index.html")).add(SOURCE.append(TEST_PRIMARY).template("HomePage.spec.tsx"), JHipsterModule.to(TEST_PRIMARY).append("HomePage.spec.tsx")).add(PRIMARY_APP_SOURCE.template("HomePage.tsx"), PRIMARY_APP_DESTINATION.append("HomePage.tsx")).add(PRIMARY_APP_SOURCE.template("HomePage.css"), PRIMARY_APP_DESTINATION.append("HomePage.css")).batch(WEBAPP_SOURCE.append(ASSETS), WEBAPP_DESTINATION.append(ASSETS)).addFile("JHipster-Lite-neon-blue.png").addFile("ReactLogo.png").and().and().apply(this.patchEslintConfig(properties)).apply(this.patchTsConfig(properties)).apply(this.patchVitestConfig()).build();
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchEslintConfig(JHipsterModuleProperties properties) {
        String reactConfig = "\t\tfiles: ['src/main/webapp/**/*.{ts,tsx}', 'src/test/webapp/unit/**/*.{ts,tsx}'],\n\t\textends: [...typescript.configs.recommendedTypeChecked, react],\n\t\tsettings: {\n\t\t\treact: {\n\t\t\t\tversion: 'detect',\n\t\t\t},\n\t\t},".replace("\t", properties.indentation().spaces());
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("eslint.config.js")).add(JHipsterModule.lineAfterRegex("from 'typescript-eslint'"), "import react from 'eslint-plugin-react/configs/recommended.js';")).add(JHipsterModule.regex(ReplacementCondition.always(), "\\s+\\.\\.\\.typescript\\.configs\\.recommended.*"), "")).add(JHipsterModule.regex("[ \\t]+files: \\['src/\\*/webapp/\\*\\*\\/\\*\\.ts'],"), reactConfig)).add(JHipsterModule.lineAfterRegex("globals: \\{ \\.\\.\\.globals\\.browser },"), "\t\t\tparserOptions: {\n\t\t\t\tproject: ['./tsconfig.json'],\n\t\t\t},".replace("\t", properties.indentation().spaces()))).add(JHipsterModule.regex("[ \\t]+quotes: \\['error', 'single', \\{ avoidEscape: true }],"), "\t\t\t'@typescript-eslint/no-misused-promises': [\n\t\t\t\t'error',\n\t\t\t\t{\n\t\t\t\t\tchecksVoidReturn: false,\n\t\t\t\t},\n\t\t\t],".replace("\t", properties.indentation().spaces()))).and()).and().apply(EslintShortcuts.eslintTypescriptRule("'@typescript-eslint/consistent-type-imports': 'error'", properties.indentation())).apply(EslintShortcuts.eslintTypescriptRule("'@typescript-eslint/await-thenable': 'off'", properties.indentation())).apply(EslintShortcuts.eslintTypescriptRule("'@typescript-eslint/no-explicit-any': 'off'", properties.indentation())).apply(EslintShortcuts.eslintTypescriptRule("'react/react-in-jsx-scope': 'off'", properties.indentation()));
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchTsConfig(JHipsterModuleProperties properties) {
        String pathsReplacement = "\"@/*\": [\"src/main/webapp/app/*\"],\n" + properties.indentation().times(3) + "\"@assets/*\": [\"src/main/webapp/assets/*\"]";
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("tsconfig.json")).add(JHipsterModule.text("@tsconfig/recommended/tsconfig.json"), "@tsconfig/vite-react/tsconfig.json")).add(JHipsterModule.text(DEFAULT_TSCONFIG_PATH), pathsReplacement)).and()).and().apply(TsConfigShortcuts.tsConfigCompilerOption("composite", false, properties.indentation())).apply(TsConfigShortcuts.tsConfigCompilerOption("forceConsistentCasingInFileNames", true, properties.indentation())).apply(TsConfigShortcuts.tsConfigCompilerOption("allowSyntheticDefaultImports", true, properties.indentation()));
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchVitestConfig() {
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("vitest.config.ts")).add(JHipsterModule.lineAfterRegex("from 'vitest/config';"), "import react from '@vitejs/plugin-react';")).add(JHipsterModule.text("plugins: ["), "plugins: [react(), ")).add(JHipsterModule.text("environment: 'node',"), "environment: 'jsdom',")).and()).and().apply(VitestShortcuts.vitestCoverageExclusion("src/main/webapp/app/index.tsx")).apply(VitestShortcuts.vitestCoverageExclusion("src/main/webapp/app/injections.ts"));
    }
}

