/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.tools.cypress.domain;

import java.util.function.Consumer;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CypressModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/common/cypress");
    private static final JHipsterDestination CYPRESS_COMPONENT_TESTS = JHipsterModule.to("src/test/webapp/component");
    private static final JHipsterDestination CYPRESS_E2E_TESTS = JHipsterModule.to("src/test/webapp/e2e");
    private static final String HOME = "home";
    private static final String UTILS = "utils";

    public JHipsterModule buildComponentTestsModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return CypressModuleFactory.commonCypressModuleBuilder(properties, CYPRESS_COMPONENT_TESTS).packageJson().addDevDependency(JHipsterModule.packageName("start-server-and-test"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("test:component"), JHipsterModule.scriptCommand("start-server-and-test dev http://localhost:9000 'cypress open --e2e --config-file src/test/webapp/component/cypress-config.ts'")).addScript(JHipsterModule.scriptKey("test:component:headless"), JHipsterModule.scriptCommand("start-server-and-test dev http://localhost:9000 'cypress run --headless --config-file src/test/webapp/component/cypress-config.ts'")).and().context().put("cypressTestDirectory", "component").and().apply(this.patchEslintPluginCypressComponent(properties)).build();
    }

    public JHipsterModule buildE2ETestsModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return CypressModuleFactory.commonCypressModuleBuilder(properties, CYPRESS_E2E_TESTS).packageJson().addScript(JHipsterModule.scriptKey("e2e"), JHipsterModule.scriptCommand("cypress open --e2e --config-file src/test/webapp/e2e/cypress-config.ts")).addScript(JHipsterModule.scriptKey("e2e:headless"), JHipsterModule.scriptCommand("cypress run --headless --config-file src/test/webapp/e2e/cypress-config.ts")).and().context().put("cypressTestDirectory", "e2e").and().apply(this.patchEslintPluginCypressE2E(properties)).build();
    }

    private static JHipsterModule.JHipsterModuleBuilder commonCypressModuleBuilder(JHipsterModuleProperties properties, JHipsterDestination destinationFolder) {
        return JHipsterModule.moduleBuilder(properties).packageJson().addDevDependency(JHipsterModule.packageName("cypress"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("eslint-plugin-cypress"), JHLiteNpmVersionSource.COMMON).and().files().batch(SOURCE, destinationFolder).addTemplate("cypress-config.ts").addFile("tsconfig.json").and().batch(SOURCE.append(HOME), destinationFolder.append(HOME)).addTemplate("Home.spec.ts").and().batch(SOURCE.append(UTILS), destinationFolder.append(UTILS)).addFile("Interceptor.ts").addFile("DataSelector.ts").and().and();
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchEslintPluginCypressE2E(JHipsterModuleProperties properties) {
        return this.patchEslintPluginCypress(properties, "e2e");
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchEslintPluginCypressComponent(JHipsterModuleProperties properties) {
        return this.patchEslintPluginCypress(properties, "component");
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchEslintPluginCypress(JHipsterModuleProperties properties, String path) {
        String eslintPluginCypress = "\t{\n\t\tfiles: ['src/test/webapp/%s/**/*.ts'],\n\t\textends: [...typescript.configs.recommendedTypeChecked, cypress.configs.recommended],\n\t\tlanguageOptions: {\n  \t\tparserOptions: {\n    \t\tproject: ['src/test/webapp/%s/tsconfig.json'],\n  \t\t},\n\t\t},\n\t\trules: {\n  \t\t'@typescript-eslint/no-unsafe-assignment': 'off',\n\t\t},\n\t},".formatted(path, path).replace("\t", properties.indentation().spaces());
        return moduleBuilder -> ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)moduleBuilder.optionalReplacements().in(JHipsterModule.path("eslint.config.mjs")).add(JHipsterModule.lineAfterRegex("from 'typescript-eslint'"), "import cypress from 'eslint-plugin-cypress/flat';")).add(JHipsterModule.lineAfterRegex(".configs.recommended,"), eslintPluginCypress)).and()).and().optionalReplacements().in(JHipsterModule.path("eslint.config.js")).add(JHipsterModule.lineAfterRegex("from 'typescript-eslint'"), "import cypress from 'eslint-plugin-cypress/flat';")).add(JHipsterModule.lineAfterRegex(".configs.recommended,"), eslintPluginCypress);
    }
}

