/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.vue.core.domain;

import java.util.function.Consumer;
import tech.jhipster.lite.generator.typescript.common.domain.EslintShortcuts;
import tech.jhipster.lite.generator.typescript.common.domain.TsConfigShortcuts;
import tech.jhipster.lite.generator.typescript.common.domain.VitestShortcuts;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmLazyInstaller;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class VueModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/vue");
    private static final JHipsterSource APP_SOURCE = JHipsterModule.from("client/vue/webapp/app");
    private static final JHipsterSource PIQURE_SOURCE = JHipsterModule.from("client/common/piqure");
    private static final JHipsterSource DOCUMENTATION_SOURCE = SOURCE.append("documentation");
    private static final JHipsterSource IMAGE_SOURCE = SOURCE.append("webapp/content/images");
    private static final JHipsterDestination MAIN_DESTINATION = JHipsterModule.to("src/main/webapp/app");
    private static final JHipsterDestination TEST_DESTINATION = JHipsterModule.to("src/test/webapp");
    private static final String IMPORT_NEEDLE = "// jhipster-needle-main-ts-import";
    private static final String PROVIDER_NEEDLE = "// jhipster-needle-main-ts-provider";
    private static final String PINIA_IMPORTS = "import { createPinia } from 'pinia';\nimport piniaPersist from 'pinia-plugin-persistedstate';\n";
    private static final String PINIA_PROVIDER = "const pinia = createPinia();\npinia.use(piniaPersist);\napp.use(pinia);\n";
    private final NpmLazyInstaller npmLazyInstaller;

    public VueModuleFactory(NpmLazyInstaller npmLazyInstaller) {
        this.npmLazyInstaller = npmLazyInstaller;
    }

    public JHipsterModule buildVueModule(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).preCommitActions(JHipsterModule.stagedFilesFilter("{src/**/,}*.{ts,vue}"), JHipsterModule.preCommitCommands("eslint --fix", "prettier --write")).documentation(JHipsterModule.documentationTitle("Vue"), DOCUMENTATION_SOURCE.file("vue.md")).packageJson().removeDevDependency(JHipsterModule.packageName("@tsconfig/recommended")).addDependency(JHipsterModule.packageName("vue"), JHLiteNpmVersionSource.VUE).addDependency(JHipsterModule.packageName("axios"), JHLiteNpmVersionSource.VUE).addDependency(JHipsterModule.packageName("vue-router"), JHLiteNpmVersionSource.VUE).addDependency(JHipsterModule.packageName("piqure"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("@vitejs/plugin-vue"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/test-utils"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("@vue/tsconfig"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("eslint-plugin-vue"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("jsdom"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vite"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("vue-tsc"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("@types/sinon"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("sinon"), JHLiteNpmVersionSource.VUE).addScript(JHipsterModule.scriptKey("build"), JHipsterModule.scriptCommand("npm-run-all build:*")).addScript(JHipsterModule.scriptKey("build:tsc"), JHipsterModule.scriptCommand("vue-tsc -p tsconfig.build.json --noEmit")).addScript(JHipsterModule.scriptKey("build:vite"), JHipsterModule.scriptCommand("vite build --emptyOutDir")).addScript(JHipsterModule.scriptKey("dev"), JHipsterModule.scriptCommand("npm-run-all --parallel dev:*")).addScript(JHipsterModule.scriptKey("dev:vite"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("preview"), JHipsterModule.scriptCommand("vite preview")).addScript(JHipsterModule.scriptKey("start"), JHipsterModule.scriptCommand("vite")).addScript(JHipsterModule.scriptKey("watch:tsc"), JHipsterModule.scriptCommand("npm run build:tsc -- --watch")).and().postActions().add(context -> this.npmLazyInstaller.runInstallIn(context.projectFolder())).and().files().add(SOURCE.file("tsconfig.build.json"), JHipsterModule.to("tsconfig.build.json")).batch(SOURCE, JHipsterModule.to(".")).addTemplate("vite.config.ts").and().add(SOURCE.template("webapp/index.html"), JHipsterModule.to("src/main/webapp/index.html")).batch(APP_SOURCE, MAIN_DESTINATION).addTemplate("env.d.ts").addTemplate("main.ts").addTemplate("AppVue.vue").addTemplate("router.ts").and().batch(PIQURE_SOURCE, MAIN_DESTINATION).addTemplate("injections.ts").and().batch(APP_SOURCE.append("home"), MAIN_DESTINATION.append("home")).addTemplate("application/HomeRouter.ts").addTemplate("infrastructure/primary/HomepageVue.vue").and().add(APP_SOURCE.template("shared/http/infrastructure/secondary/AxiosHttp.ts.mustache"), MAIN_DESTINATION.append("shared/http/infrastructure/secondary/AxiosHttp.ts")).batch(IMAGE_SOURCE, JHipsterModule.to("src/main/webapp/content/images")).addFile("JHipster-Lite-neon-green.png").addFile("VueLogo.png").and().add(SOURCE.template("webapp/app/router.ts"), MAIN_DESTINATION.append("router.ts")).add(SOURCE.template("Dummy.spec.ts"), JHipsterModule.to("src/test/webapp/unit/Dummy.spec.ts")).add(APP_SOURCE.template("test/webapp/unit/shared/http/infrastructure/secondary/AxiosHttp.spec.ts.mustache"), TEST_DESTINATION.append("unit/shared/http/infrastructure/secondary/AxiosHttp.spec.ts")).add(APP_SOURCE.template("test/webapp/unit/shared/http/infrastructure/secondary/AxiosStub.ts.mustache"), TEST_DESTINATION.append("unit/shared/http/infrastructure/secondary/AxiosStub.ts")).add(APP_SOURCE.template("test/webapp/unit/router/infrastructure/primary/HomeRouter.spec.ts.mustache"), TEST_DESTINATION.append("unit/router/infrastructure/primary/HomeRouter.spec.ts")).and().apply(this.patchEslintConfig(properties)).apply(this.patchTsConfig(properties)).apply(this.patchVitestConfig()).build();
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchEslintConfig(JHipsterModuleProperties properties) {
        String vuePluginConfig = "\t...vue.configs['flat/recommended'],\n\t{\n\t\tfiles: ['**/*.vue'],\n\t\tlanguageOptions: {\n\t\t\tparserOptions: { parser: '@typescript-eslint/parser' },\n\t\t\tglobals: { ...globals.browser },\n\t\t},\n\t},".replace("\t", properties.indentation().spaces());
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("eslint.config.js")).add(JHipsterModule.lineAfterRegex("from '@eslint/js'"), "import vue from 'eslint-plugin-vue';")).add(JHipsterModule.lineAfterRegex("...typescript.configs.recommended"), vuePluginConfig)).add(JHipsterModule.text("files: ['src/*/webapp/**/*.ts']"), "files: ['src/*/webapp/**/*.vue', 'src/*/webapp/**/*.ts']")).and()).and().apply(EslintShortcuts.eslintTypescriptRule("'vue/html-self-closing': 'off'", properties.indentation())).apply(EslintShortcuts.eslintTypescriptRule("'@typescript-eslint/no-explicit-any': 'off'", properties.indentation())).apply(EslintShortcuts.eslintTypescriptRule("'@typescript-eslint/no-empty-object-type': 'off'", properties.indentation())).apply(EslintShortcuts.eslintTypescriptRule("'@typescript-eslint/consistent-type-imports': 'error'", properties.indentation()));
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchTsConfig(JHipsterModuleProperties properties) {
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("tsconfig.json")).add(JHipsterModule.text("@tsconfig/recommended/tsconfig.json"), "@vue/tsconfig/tsconfig.dom.json")).add(JHipsterModule.text("\"types\": ["), "\"types\": [\"vite/client\", ")).and()).and().apply(TsConfigShortcuts.tsConfigCompilerOption("sourceMap", true, properties.indentation())).apply(TsConfigShortcuts.tsConfigCompilerOption("allowJs", true, properties.indentation()));
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> patchVitestConfig() {
        return moduleBuilder -> ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)moduleBuilder.mandatoryReplacements().in(JHipsterModule.path("vitest.config.ts")).add(JHipsterModule.lineAfterRegex("from 'vitest/config';"), "import vue from '@vitejs/plugin-vue';")).add(JHipsterModule.text("plugins: ["), "plugins: [vue(), ")).add(JHipsterModule.text("environment: 'node',"), "environment: 'jsdom',")).and()).and().apply(VitestShortcuts.vitestCoverageExclusion("src/main/webapp/**/*.component.ts")).apply(VitestShortcuts.vitestCoverageExclusion("src/main/webapp/app/router.ts")).apply(VitestShortcuts.vitestCoverageExclusion("src/main/webapp/app/injections.ts")).apply(VitestShortcuts.vitestCoverageExclusion("src/main/webapp/app/main.ts"));
    }

    public JHipsterModule buildPiniaModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).packageJson().addDependency(JHipsterModule.packageName("pinia"), JHLiteNpmVersionSource.VUE).addDependency(JHipsterModule.packageName("pinia-plugin-persistedstate"), JHLiteNpmVersionSource.VUE).addDevDependency(JHipsterModule.packageName("@pinia/testing"), JHLiteNpmVersionSource.VUE).and().mandatoryReplacements().in(JHipsterModule.path("src/main/webapp/app/main.ts")).add(JHipsterModule.lineBeforeText(IMPORT_NEEDLE), PINIA_IMPORTS)).add(JHipsterModule.lineBeforeText(PROVIDER_NEEDLE), PINIA_PROVIDER)).and()).and().build();
    }
}

