/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.frontendmaven.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class FrontendJavaBuildToolModuleFactory {
    private static final String PACKAGE_INFO = "package-info.java";
    private static final String PROPERTIES_FIELD = "properties";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/frontend");
    private static final String REDIRECTION = "wire/frontend";
    private static final String REDIRECTION_PRIMARY = "wire/frontend/infrastructure/primary";
    private final NpmVersions npmVersions;

    public FrontendJavaBuildToolModuleFactory(NpmVersions npmVersions) {
        this.npmVersions = npmVersions;
    }

    public JHipsterModule buildFrontendMavenModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        return FrontendJavaBuildToolModuleFactory.commonModuleFiles(properties).javaBuildProperties().set(JHipsterModule.buildPropertyKey("node.version"), JHipsterModule.buildPropertyValue("v" + this.npmVersions.nodeVersion().get())).set(JHipsterModule.buildPropertyKey("npm.version"), JHipsterModule.buildPropertyValue(this.npmVersions.get("npm", JHLiteNpmVersionSource.COMMON).get())).and().mavenPlugins().plugin(this.frontendMavenPlugin().build()).and().build();
    }

    public JHipsterModule buildFrontendMavenCacheModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        return JHipsterModule.moduleBuilder(properties).mavenPlugins().plugin(this.checksumPlugin()).plugin(this.antrunPlugin()).and().build();
    }

    private MavenPlugin checksumPlugin() {
        return JHipsterModule.mavenPlugin().groupId("net.nicoulaj.maven.plugins").artifactId("checksum-maven-plugin").versionSlug("checksum-maven-plugin").addExecution(JHipsterModule.pluginExecution().goals("files").id("create-pre-compiled-webapp-checksum").phase(MavenBuildPhase.GENERATE_RESOURCES)).addExecution(JHipsterModule.pluginExecution().goals("files").id("create-compiled-webapp-checksum").phase(MavenBuildPhase.COMPILE).configuration("<csvSummaryFile>checksums.csv.old</csvSummaryFile>\n")).configuration("  <fileSets>\n    <fileSet>\n      <directory>${project.basedir}</directory>\n      <includes>\n        <include>src/main/webapp/**/*.*</include>\n        <include>target/classes/static/**/*.*</include>\n        <include>package-lock.json</include>\n        <include>package.json</include>\n        <include>tsconfig.json</include>\n      </includes>\n    </fileSet>\n  </fileSets>\n  <failOnError>false</failOnError>\n  <failIfNoFiles>false</failIfNoFiles>\n  <individualFiles>false</individualFiles>\n  <algorithms>\n    <algorithm>SHA-1</algorithm>\n  </algorithms>\n  <includeRelativePath>true</includeRelativePath>\n  <quiet>true</quiet>\n").build();
    }

    private MavenPlugin antrunPlugin() {
        return JHipsterModule.mavenPlugin().groupId("org.apache.maven.plugins").artifactId("maven-antrun-plugin").versionSlug("maven-antrun-plugin").addExecution(JHipsterModule.pluginExecution().goals("run").id("eval-frontend-checksum").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<target>\n  <condition property=\"skip.npm\" value=\"true\" else=\"false\">\n    <and>\n      <available file=\"checksums.csv\" filepath=\"${project.build.directory}\" />\n      <available file=\"checksums.csv.old\" filepath=\"${project.build.directory}\" />\n      <filesmatch file1=\"${project.build.directory}/checksums.csv\" file2=\"${project.build.directory}/checksums.csv.old\" />\n    </and>\n  </condition>\n</target>\n<exportAntProperties>true</exportAntProperties>\n")).build();
    }

    private MavenPlugin.MavenPluginOptionalBuilder frontendMavenPlugin() {
        return JHipsterModule.mavenPlugin().groupId("com.github.eirslett").artifactId("frontend-maven-plugin").versionSlug("frontend-maven-plugin").configuration("<installDirectory>${project.build.directory}</installDirectory>").addExecution(JHipsterModule.pluginExecution().goals("install-node-and-npm").id("install-node-and-npm").configuration("<nodeVersion>${node.version}</nodeVersion>\n<npmVersion>${npm.version}</npmVersion>\n")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("npm install")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("build front").phase(MavenBuildPhase.GENERATE_RESOURCES).configuration("<arguments>run build</arguments>\n<environmentVariables>\n  <APP_VERSION>${project.version}</APP_VERSION>\n</environmentVariables>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("front test").phase(MavenBuildPhase.TEST).configuration("<arguments>run test:coverage</arguments>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n"));
    }

    public JHipsterModule buildFrontendGradleModule(JHipsterModuleProperties properties) {
        return FrontendJavaBuildToolModuleFactory.commonModuleFiles(properties).javaBuildProperties().set(JHipsterModule.buildPropertyKey("node.version.value"), JHipsterModule.buildPropertyValue(this.npmVersions.nodeVersion().get())).set(JHipsterModule.buildPropertyKey("npm.version.value"), JHipsterModule.buildPropertyValue(this.npmVersions.get("npm", JHLiteNpmVersionSource.COMMON).get())).and().gradlePlugins().plugin(this.frontendGradlePlugin()).and().gradleConfigurations().addTasksTestInstruction("dependsOn(\"testNpm\")").and().build();
    }

    public JHipsterModule buildMergeCypressCoverageModule(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        return FrontendJavaBuildToolModuleFactory.commonModuleFiles(properties).javaBuildProperties().set(JHipsterModule.buildPropertyKey("node.version"), JHipsterModule.buildPropertyValue("v" + this.npmVersions.nodeVersion().get())).set(JHipsterModule.buildPropertyKey("npm.version"), JHipsterModule.buildPropertyValue(this.npmVersions.get("npm", JHLiteNpmVersionSource.COMMON).get())).and().mavenPlugins().plugin(this.mergeCypressPlugin()).and().build();
    }

    private static JHipsterModule.JHipsterModuleBuilder commonModuleFiles(JHipsterModuleProperties properties) {
        Assert.notNull(PROPERTIES_FIELD, properties);
        String packagePath = properties.packagePath();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(packagePath);
        return JHipsterModule.moduleBuilder(properties).files().add(SOURCE.template("RedirectionResource.java"), mainDestination.append(REDIRECTION_PRIMARY).append("RedirectionResource.java")).add(SOURCE.template(PACKAGE_INFO), mainDestination.append(REDIRECTION).append(PACKAGE_INFO)).and();
    }

    private GradleMainBuildPlugin frontendGradlePlugin() {
        return JHipsterModule.gradleCommunityPlugin().id("com.github.node-gradle.node").pluginSlug("node-gradle").versionSlug("node-gradle").withBuildGradleImport("com.github.gradle.node.npm.task.NpmTask").configuration("node {\n  download.set(true)\n  version.set(nodeVersionValue)\n  npmVersion.set(npmVersionValue)\n  workDir.set(file(layout.buildDirectory))\n  npmWorkDir.set(file(layout.buildDirectory))\n}\n\nval buildTaskUsingNpm = tasks.register<NpmTask>(\"buildNpm\") {\n  description = \"Build the frontend project using NPM\"\n  group = \"Build\"\n  dependsOn(\"npmInstall\")\n  npmCommand.set(listOf(\"run\", \"build\"))\n  environment.set(mapOf(\"APP_VERSION\" to project.version.toString()))\n}\n\nval testTaskUsingNpm = tasks.register<NpmTask>(\"testNpm\") {\n  description = \"Test the frontend project using NPM\"\n  group = \"verification\"\n  dependsOn(\"npmInstall\", \"buildNpm\")\n  npmCommand.set(listOf(\"run\", \"test:coverage\"))\n  ignoreExitValue.set(false)\n  workingDir.set(projectDir)\n  execOverrides {\n    standardOutput = System.out\n  }\n}\n\ntasks.bootJar {\n  dependsOn(\"buildNpm\")\n  from(\"build/classes/static\") {\n      into(\"BOOT-INF/classes/static\")\n  }\n}\n").build();
    }

    private MavenPlugin mergeCypressPlugin() {
        return this.frontendMavenPlugin().addExecution(JHipsterModule.pluginExecution().goals("npm").id("front component test").phase(MavenBuildPhase.TEST).configuration("<arguments>run test:component:headless</arguments>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n")).addExecution(JHipsterModule.pluginExecution().goals("npm").id("front verify coverage").phase(MavenBuildPhase.TEST).configuration("<arguments>run test:coverage:check</arguments>\n<npmInheritsProxyConfigFromMaven>false</npmInheritsProxyConfigFromMaven>\n")).build();
    }
}

