/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.broker.kafka.domain;

import java.util.UUID;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class KafkaModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/broker/kafka");
    private static final String TECHNICAL_INFRASTRUCTURE_CONFIG_KAFKA = "/wire/kafka/infrastructure/config";
    private static final String SAMPLE_INFRASTRUCTURE_SECONDARY_KAFKA_PRODUCER = "sample/infrastructure/secondary/kafka/producer";
    private static final String SAMPLE_INFRASTRUCTURE_PRIMARY_KAFKA_CONSUMER = "sample/infrastructure/primary/kafka/consumer";
    private static final String STRING_DESERIALIZER = "org.apache.kafka.common.serialization.StringDeserializer";
    private static final String STRING_SERIALIZER = "org.apache.kafka.common.serialization.StringSerializer";
    private final DockerImages dockerImages;

    public KafkaModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModuleInit(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        String kafkaClusterId = properties.getOrDefaultString("kafkaClusterId", UUID.randomUUID().toString());
        return JHipsterModule.moduleBuilder(properties).context().put("kafkaDockerImage", this.dockerImages.get("apache/kafka-native").fullName()).put("kafkaClusterId", kafkaClusterId).and().documentation(JHipsterModule.documentationTitle("Apache Kafka"), SOURCE.template("apache-kafka.md")).startupCommands().dockerCompose("src/main/docker/kafka.yml").and().javaDependencies().addDependency(JHipsterModule.groupId("org.apache.kafka"), JHipsterModule.artifactId("kafka-clients"), JHipsterModule.versionSlug("kafka-clients.version")).addDependency(JHipsterModule.groupId("org.testcontainers"), JHipsterModule.artifactId("kafka"), JHipsterModule.versionSlug("testcontainers.version")).and().files().add(SOURCE.template("kafka.yml"), JHipsterModule.toSrcMainDocker().append("kafka.yml")).add(SOURCE.template("KafkaTestContainerExtension.java"), JHipsterModule.toSrcTestJava().append(packagePath + "/KafkaTestContainerExtension.java")).add(SOURCE.template("KafkaPropertiesTest.java"), JHipsterModule.toSrcTestJava().append(packagePath + "//wire/kafka/infrastructure/config/KafkaPropertiesTest.java")).add(SOURCE.template("KafkaProperties.java"), JHipsterModule.toSrcMainJava().append(packagePath + "//wire/kafka/infrastructure/config/KafkaProperties.java")).add(SOURCE.template("KafkaConfiguration.java"), JHipsterModule.toSrcMainJava().append(packagePath + "//wire/kafka/infrastructure/config/KafkaConfiguration.java")).and().integrationTestExtension("KafkaTestContainerExtension").springMainProperties().set(JHipsterModule.propertyKey("kafka.bootstrap-servers"), JHipsterModule.propertyValue("localhost:9092")).set(JHipsterModule.propertyKey("kafka.consumer.'[key.deserializer]'"), JHipsterModule.propertyValue(STRING_DESERIALIZER)).set(JHipsterModule.propertyKey("kafka.consumer.'[value.deserializer]'"), JHipsterModule.propertyValue(STRING_DESERIALIZER)).set(JHipsterModule.propertyKey("kafka.consumer.'[group.id]'"), JHipsterModule.propertyValue("myapp")).set(JHipsterModule.propertyKey("kafka.consumer.'[auto.offset.reset]'"), JHipsterModule.propertyValue("earliest")).set(JHipsterModule.propertyKey("kafka.producer.'[key.serializer]'"), JHipsterModule.propertyValue(STRING_SERIALIZER)).set(JHipsterModule.propertyKey("kafka.producer.'[value.serializer]'"), JHipsterModule.propertyValue(STRING_SERIALIZER)).set(JHipsterModule.propertyKey("kafka.polling.timeout"), JHipsterModule.propertyValue(10000)).and().dockerComposeFile().append(JHipsterModule.dockerComposeFile("src/main/docker/kafka.yml")).and().springTestProperties().set(JHipsterModule.propertyKey("kafka.bootstrap-servers"), JHipsterModule.propertyValue("localhost:9092")).and().build();
    }

    public JHipsterModule buildModuleSampleProducerConsumer(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).springMainProperties().set(JHipsterModule.propertyKey("kafka.topic.sample"), JHipsterModule.propertyValue("queue." + properties.projectBaseName().name() + ".sample")).and().files().add(SOURCE.template("SampleProducer.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_SECONDARY_KAFKA_PRODUCER).append("SampleProducer.java")).add(SOURCE.template("SampleProducerTest.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_SECONDARY_KAFKA_PRODUCER).append("/SampleProducerTest.java")).add(SOURCE.template("SampleProducerIT.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_SECONDARY_KAFKA_PRODUCER).append("/SampleProducerIT.java")).add(SOURCE.template("AbstractConsumer.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_PRIMARY_KAFKA_CONSUMER).append("/AbstractConsumer.java")).add(SOURCE.template("SampleConsumer.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_PRIMARY_KAFKA_CONSUMER).append("/SampleConsumer.java")).add(SOURCE.template("SampleConsumerTest.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_PRIMARY_KAFKA_CONSUMER).append("/SampleConsumerTest.java")).add(SOURCE.template("SampleConsumerIT.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(SAMPLE_INFRASTRUCTURE_PRIMARY_KAFKA_CONSUMER).append("/SampleConsumerIT.java")).and().build();
    }

    public JHipsterModule buildModuleAkhq(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).context().put("akhqDockerImage", this.dockerImages.get("tchiotludo/akhq").fullName()).and().files().add(SOURCE.template("akhq.yml"), JHipsterModule.toSrcMainDocker().append("akhq.yml")).and().startupCommands().dockerCompose("src/main/docker/akhq.yml").and().build();
    }
}

