/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.broker.kafka.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.broker.kafka.application.KafkaApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class KafkaModuleConfiguration {
    private static final String TAG = "Spring Boot - Broker";
    private static final String BROKER = "broker";
    private static final String SPRING_BOOT_TAG = "spring-boot";
    private static final String SPRING = "spring";
    private static final String SERVER = "server";

    KafkaModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource kafkaResourceInit(KafkaApplicationService kafka) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SPRING_BOOT_KAFKA).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().addSpringConfigurationFormat().build()).apiDoc(TAG, "Add Kafka dependencies, with testcontainers").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.SPRING_BOOT).build()).tags(SERVER, SPRING, SPRING_BOOT_TAG, BROKER).factory(kafka::init);
    }

    @Bean
    JHipsterModuleResource kafkaResourceSampleProducerConsumer(KafkaApplicationService kafka) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SPRING_BOOT_KAFKA_SAMPLE_PRODUCER_CONSUMER).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().addSpringConfigurationFormat().build()).apiDoc("Sample Feature", "Add sample Kafka producer and consumer").organization(this.kafkaDependency()).tags(SERVER, SPRING, SPRING_BOOT_TAG, BROKER).factory(kafka::addSampleProducerConsumer);
    }

    @Bean
    JHipsterModuleResource kafkaResourceAkhq(KafkaApplicationService kafka) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SPRING_BOOT_KAFKA_AKHQ).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addIndentation().build()).apiDoc(TAG, "Add AKHQ").organization(this.kafkaDependency()).tags(SERVER, SPRING, SPRING_BOOT_TAG, BROKER).factory(kafka::addAkhq);
    }

    private JHipsterModuleOrganization kafkaDependency() {
        return JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.SPRING_BOOT_KAFKA).build();
    }
}

