/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.customjhlite.domain;

import java.util.function.Consumer;
import tech.jhipster.lite.generator.server.springboot.cucumbercommon.domain.CucumbersModules;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CustomJHLiteModuleFactory {
    private static final String DOMAIN = "domain";
    private static final String SHARED = "shared";
    private static final String INFRASTRUCTURE = "infrastructure";
    private static final String SECONDARY = "secondary";
    private static final String DEPENDENCIES = "dependencies";
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/custom-jhlite");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final JHipsterSource SLUG_SOURCE = MAIN_SOURCE.append("shared").append("slug");
    private static final JHipsterSource DEPENDENCIES_MAIN_SOURCE = MAIN_SOURCE.append("shared").append("dependencies");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test");
    private static final JHipsterSource DEPENDENCIES_TEST_SOURCE = TEST_SOURCE.append("shared").append("dependencies");
    private static final JHipsterSource CUCUMBER_SOURCE = JHipsterModule.from("server/springboot/cucumber");
    private static final String SRC_MAIN_JAVA = "src/main/java";
    private static final PropertyKey SERVER_PORT_KEY = JHipsterModule.propertyKey("server.port");
    private static final PropertyKey JACKSON_INCLUSION_KEY = JHipsterModule.propertyKey("spring.jackson.default-property-inclusion");
    private static final PropertyKey HIDDEN_SLUGS_PROPERTY_KEY = JHipsterModule.propertyKey("jhlite.hidden-resources.slugs");
    private static final PropertyKey BEAN_DEFINITION_OVERRIDING_PROPERTY_KEY = JHipsterModule.propertyKey("spring.main.allow-bean-definition-overriding");
    private static final String PACKAGE_INFO_JAVA = "package-info.java";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)CucumbersModules.cucumberModuleBuilder(properties).context().put("baseName", properties.projectBaseName().capitalized()).and().documentation(JHipsterModule.documentationTitle("Module creation"), SOURCE.template("module-creation.md")).javaDependencies().addDependency(this.jhipsterLiteDependency()).addDependency(this.jhipsterLiteTestDependency()).addTestDependency(JHipsterModule.groupId("com.approvaltests"), JHipsterModule.artifactId("approvaltests"), JHipsterModule.versionSlug("approvaltests")).and().mandatoryReplacements().in(this.mainClassFile(properties)).add(JHipsterModule.text("@SpringBootApplication"), this.springBootApplicationWithJHLite(properties))).add(JHipsterModule.lineBeforeText("import org.springframework.boot.SpringApplication;"), "import tech.jhipster.lite.JHLiteApp;")).and()).and().springMainProperties().set(SERVER_PORT_KEY, JHipsterModule.propertyValue(properties.serverPort().get())).set(JACKSON_INCLUSION_KEY, JHipsterModule.propertyValue("non_null")).comment(HIDDEN_SLUGS_PROPERTY_KEY, JHipsterModule.comment("Disable the modules and its dependencies by slugs")).set(HIDDEN_SLUGS_PROPERTY_KEY, JHipsterModule.propertyValue("custom-jhlite")).and().springTestProperties().set(SERVER_PORT_KEY, JHipsterModule.propertyValue(0)).set(BEAN_DEFINITION_OVERRIDING_PROPERTY_KEY, JHipsterModule.propertyValue(true)).and().files().batch(SOURCE.append("tests-ci"), JHipsterModule.to("tests-ci")).addExecutableTemplate("generate.sh").addTemplate("modulePayload.json").addExecutableTemplate("start.sh").addExecutable("stop.sh").and().and().apply(this.cucumberBuilder(properties)).apply(this.dependenciesReadersBuilder(properties)).apply(this.slugBuilder(properties)).build();
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> cucumberBuilder(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        JHipsterDestination cucumberDestination = JHipsterModule.toSrcTestJava().append(packagePath).append("cucumber");
        return builder -> builder.documentation(JHipsterModule.documentationTitle("Cucumber"), CUCUMBER_SOURCE.template("cucumber.md")).files().batch(TEST_SOURCE, cucumberDestination).addTemplate("CucumberTest.java").addTemplate("CucumberConfiguration.java").and().add(CUCUMBER_SOURCE.append("rest").template("CucumberRestTemplate.java"), cucumberDestination.append("rest").append("CucumberRestTemplate.java")).add(CUCUMBER_SOURCE.file("gitkeep"), JHipsterModule.to("src/test/features/.gitkeep"));
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> dependenciesReadersBuilder(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        String baseName = properties.projectBaseName().capitalized();
        JHipsterDestination npmMainDestination = JHipsterModule.toSrcMainJava().append(packagePath).append(SHARED).append(DEPENDENCIES);
        JHipsterDestination npmTestDestination = JHipsterModule.toSrcTestJava().append(packagePath).append(SHARED).append(DEPENDENCIES);
        return builder -> builder.context().put("baseNameUpperCased", properties.projectBaseName().upperCased()).put("baseNameKebabCased", properties.projectBaseName().kebabCase()).and().files().add(DEPENDENCIES_MAIN_SOURCE.template(PACKAGE_INFO_JAVA), npmMainDestination.append(PACKAGE_INFO_JAVA)).add(DEPENDENCIES_MAIN_SOURCE.append(DOMAIN).template("NpmVersionSource.java"), npmMainDestination.append(DOMAIN).append(baseName + "NpmVersionSource.java")).add(DEPENDENCIES_MAIN_SOURCE.append(INFRASTRUCTURE).append(SECONDARY).template("NpmVersionReader.java"), npmMainDestination.append(INFRASTRUCTURE).append(SECONDARY).append(baseName + "NpmVersionReader.java")).add(DEPENDENCIES_MAIN_SOURCE.append(INFRASTRUCTURE).append(SECONDARY).template("MavenDependenciesReader.java"), npmMainDestination.append(INFRASTRUCTURE).append(SECONDARY).append(baseName + "MavenDependenciesReader.java")).add(DEPENDENCIES_TEST_SOURCE.append(INFRASTRUCTURE).append(SECONDARY).template("NpmVersionReaderTest.java"), npmTestDestination.append(INFRASTRUCTURE).append(SECONDARY).append(baseName + "NpmVersionReaderTest.java")).add(DEPENDENCIES_TEST_SOURCE.append(INFRASTRUCTURE).append(SECONDARY).template("MavenDependenciesReaderTest.java"), npmTestDestination.append(INFRASTRUCTURE).append(SECONDARY).append(baseName + "MavenDependenciesReaderTest.java")).add(SOURCE.file("package.json"), JHipsterModule.toSrcMainResources().append("generator").append(properties.projectBaseName().kebabCase() + "-dependencies").append(properties.projectBaseName().kebabCase()).append("package.json")).add(SOURCE.file("pom.xml.mustache"), JHipsterModule.toSrcMainResources().append("generator").append(properties.projectBaseName().kebabCase() + "-dependencies").append("pom.xml"));
    }

    private Consumer<JHipsterModule.JHipsterModuleBuilder> slugBuilder(JHipsterModuleProperties properties) {
        String packagePath = properties.packagePath();
        String baseName = properties.projectBaseName().capitalized();
        JHipsterDestination slugDestination = JHipsterModule.toSrcMainJava().append(packagePath).append(SHARED).append("slug");
        return builder -> builder.files().add(SLUG_SOURCE.template(PACKAGE_INFO_JAVA), slugDestination.append(PACKAGE_INFO_JAVA)).add(SLUG_SOURCE.append(DOMAIN).template("FeatureSlug.java"), slugDestination.append(DOMAIN).append(baseName + "FeatureSlug.java")).add(SLUG_SOURCE.append(DOMAIN).template("ModuleSlug.java"), slugDestination.append(DOMAIN).append(baseName + "ModuleSlug.java"));
    }

    private JavaDependency jhipsterLiteDependency() {
        return this.jhLiteDependencyBuilder().build();
    }

    private JavaDependency jhipsterLiteTestDependency() {
        return this.jhLiteDependencyBuilder().classifier("tests").scope(JavaDependencyScope.TEST).type(JavaDependencyType.TEST_JAR).build();
    }

    private JavaDependency.JavaDependencyOptionalValueBuilder jhLiteDependencyBuilder() {
        return JHipsterModule.javaDependency().groupId("tech.jhipster.lite").artifactId("jhlite").versionSlug("jhlite");
    }

    private String springBootApplicationWithJHLite(JHipsterModuleProperties properties) {
        return "@SpringBootApplication(scanBasePackageClasses = { JHLiteApp.class, " + this.mainClassName(properties) + ".class })";
    }

    private JHipsterProjectFilePath mainClassFile(JHipsterModuleProperties properties) {
        return JHipsterModule.path(SRC_MAIN_JAVA).append(properties.packagePath()).append(this.mainClassName(properties) + ".java");
    }

    private String mainClassName(JHipsterModuleProperties properties) {
        return properties.projectBaseName().capitalized() + "App";
    }
}

